% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rdh_theory.R
\name{rdh_theory}
\alias{rdh_theory}
\title{Calculate metric based on geometric plane equation}
\usage{
rdh_theory(R, D, H, L, L0)
}
\arguments{
\item{R, D, H}{Two of the three variables to calculate the third.}

\item{L}{Extent.}

\item{L0}{Resolution.}
}
\value{
A value corresponding one of the three variables not given
to the function.
}
\description{
Calculates either rugosity, fractal dimension or height
range based on the other two variables.
}
\details{
This function uses the geometric plane equation from Torres-Pulliza
et al. (2020) to calculate one of rugosity, fractal dimension or height
range based on the other two variables.
}
\examples{
rdh_theory(R=4, H=1, L=1, L0=0.01)
rdh_theory(D=2.36928, H=1, L=1, L0=0.01)
rdh_theory(D=2.36928, R=4, L=1, L0=0.01)
}
\references{
Torres-Pulliza D, Dornelas M, Pizarro O, Bewley M, Blowes SA, Boutros N, Brambilla V, Chase TJ, Frank G, Friedman A, Hoogenboom MO, Williams S, Zawada KJA, Madin JS (2020) A geometric basis for surface habitat complexity and biodiversity. \emph{Nature Ecology & Evolution} 4:1495-1501. \doi{https://doi.org/10.1038/s41559-020-1281-8}
}
