use h3o::Resolution;
use std::{
    fs::File,
    io::{BufRead, BufReader},
    path::PathBuf,
};

#[test]
fn golden_file() {
    // Load the file generated by tools/average_edge_length
    let mut path = PathBuf::from(env!("CARGO_MANIFEST_DIR"));
    path.push("dataset/avgEdgeLen.txt");

    let file = File::open(path).expect("open test dataset");
    let reader = BufReader::new(file);
    let resolutions = Resolution::range(Resolution::Zero, Resolution::Fifteen);

    for (resolution, line) in resolutions.zip(reader.lines()) {
        let line = line.expect("test input");
        let parts = line.split(',').collect::<Vec<&str>>();
        let avg_rad = parts[0].parse::<f64>().expect("edge len in radians");
        let avg_km = parts[1].parse::<f64>().expect("edge len in kilometers");
        let avg_m = parts[2].parse::<f64>().expect("edge len in meters");

        assert_eq!(
            resolution.edge_length_rads(),
            avg_rad,
            "avg edge len rad at {resolution}"
        );
        assert_eq!(
            resolution.edge_length_km(),
            avg_km,
            "avg edge len km at {resolution}"
        );
        assert_eq!(
            resolution.edge_length_m(),
            avg_m,
            "avg edge len m at {resolution}"
        );
    }
}
