% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/custom_fuctions.R
\name{cell_to_line}
\alias{cell_to_line}
\alias{cell_to_line.data.frame}
\alias{cell_to_line.list}
\alias{cell_to_line.character}
\title{Convert H3 cell indexes to a line}
\usage{
cell_to_line(input = NULL, simple = TRUE)

\method{cell_to_line}{data.frame}(input = NULL, simple = TRUE)

\method{cell_to_line}{list}(input = NULL, simple = TRUE)

\method{cell_to_line}{character}(input = NULL, simple = TRUE)
}
\arguments{
\item{input}{Character vector of 15-character indexes generated by H3, a
list of such, or a data frame where the last column is a list-column of H3
cell indexes (usually the output of
\code{\link[h3jsr:grid_path]{h3jsr::grid_path()}}.}

\item{simple}{Logical; whether to return an \code{sfc_LINESTRING} object or
an \code{sf} data frame containing both inputs and outputs.}
}
\value{
An \code{sfc_LINESTRING} object containing a line for each vector of
  H3 cell indexes supplied. If \code{simple = FALSE}, an \code{sf} object
  including the input data.
}
\description{
Return line geometry for a sequence of H3 cell indexes in WGS84 coordinates.
}
\note{
This function can accept any arbitrary vector of cell indexes (including
  cells at multiple resolutions) but results may be unexpected. It is
  assumed that indexes are supplied in a pre-ordered fashion.
}
\examples{
# What is the cell index over the Brisbane Town Hall at resolution 10?
brisbane_hex_10 <- cell_to_polygon(input = '8abe8d12acaffff')

# Give me a some nearby cells
hex_sample <- get_disk_list('8abe8d12acaffff', 4)[[1]][[4]][seq(1,18,3)]
hex_sample_polys <- cell_to_polygon(hex_sample)

# find connecting paths
paths <- grid_path(rep('8abe8d12acaffff', 6), hex_sample)

# make lines
lines <- cell_to_line(paths)

\dontrun{
plot(hex_sample_polys, reset = FALSE)
plot(brisbane_hex_10, add = TRUE)
plot(lines, col = 'red', add = TRUE)
}

}
