% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/post-traits.R
\name{get_child_efo}
\alias{get_child_efo}
\title{Get all child terms of this trait in the EFO hierarchy}
\usage{
get_child_efo(
  efo_id,
  verbose = FALSE,
  warnings = TRUE,
  page_size = 20L,
  progress_bar = TRUE
)
}
\arguments{
\item{efo_id}{A character vector of \href{https://www.ebi.ac.uk/efo/}{EFO}
identifiers.}

\item{verbose}{A \code{logical} indicating whether the function should be
verbose about the different queries or not.}

\item{warnings}{A \code{logical} indicating whether to print warnings, if any.}

\item{page_size}{An \code{integer} scalar indicating the
\href{https://www.ebi.ac.uk/gwas/rest/docs/api#_paging_resources}{page}
value to be used in the JSON requests, can be between \code{1} and
\code{1000}.}

\item{progress_bar}{Whether to show a progress bar as the paginated resources
are retrieved.}
}
\value{
A named list whose values are character vectors of EFO identifiers.
}
\description{
Get all child terms of this trait in the EFO hierarchy
}
\examples{
\dontrun{
get_child_efo(c('EFO_0004884', 'EFO_0004343', 'EFO_0005299'))
}
}
