\name{gsearlyUser}
\alias{gsearlyUser}
\title{User input estimates of sample size and power for group sequential
  designs with early outcomes}
\usage{gsearlyUser(trecruit, s, tfu, tinterims, ninterims, pow=0.9, n=NULL,
       tref=c(1,2), vphi=0.5, cmodel="uniform", sd=1, rho=0.5, theta, fp, tn,
       treatnames=c("control","treat"),
       sopt=list(r=18, bisect=list(min=20, max=10000, niter=1000, tol=0.001)))}
\description{Provides sample sizes and power for group sequential designs with
  early outcomes defined by a matrix of fixed numbers of participants with data
  for all outcomes (early and primary) at each interim time-point or a function
  that gives a similarly structured matrix for all sample sizes in a pre-set
  range and a correlation model or correlation matrix, recruitment period and
  interim analysis time-points.}
\arguments{
 \item{trecruit}{As for \code{\link{gsearlyModel}}.}
 \item{s}{As for \code{\link{gsearlyModel}}.}
 \item{tfu}{As for \code{\link{gsearlyModel}}.}
 \item{tinterims}{As for \code{\link{gsearlyModel}}.}
 \item{ninterims}{A matrix with \code{s + 1} columns and \code{length(interims)}
   rows giving the numbers of participants providing data or present at each
   interim analysis (row) at recruitment (first column) and at each follow-up
   time point (\code{tfu}) in columns 2 to \code{s + 1}. Alternatively, a
   function fn(x) that gives a matrix of these dimensions for sample sizes x in
   the range \code{(sopt$bisect$min, sopt$bisect$max)}. Currently this is only
   implemented and tested for functions based on fixed proportions.}
 \item{pow}{As for \code{\link{gsearlyModel}}.}
 \item{n}{As for \code{\link{gsearlyModel}}.}
 \item{tref}{As for \code{\link{gsearlyModel}}.}
 \item{vphi}{As for \code{\link{gsearlyModel}}.}
 \item{cmodel}{Either a correlation model, \code{c("uniform", "exponential")},
   defined by correlation parameter \code{rho}, or a user supplied correlation
   matrix of dimensions \code{s} x \code{s}.}
 \item{sd}{As for \code{\link{gsearlyModel}}.}
 \item{rho}{As for \code{\link{gsearlyModel}} if \code{cmodel} is set to
   \code{"uniform"} or \code{"exponential"}, otherwise ignored.}
 \item{theta}{As for \code{\link{gsearlyModel}}.}
 \item{fp}{As for \code{\link{gsearlyModel}}.}
 \item{tn}{As for \code{\link{gsearlyModel}}.}
 \item{treatnames}{As for \code{\link{gsearlyModel}}.}
 \item{sopt}{As for \code{\link{gsearlyModel}}.}
}
\value{
 An object of class gsearly is a list containing the following components
 \item{title}{Package title and version number.}
 \item{call}{Call to \code{gsearlyUser}.}
 \item{rdata}{A list of same structure as for \code{\link{gsearlyModel}} with
   the recruitment model set to \code{"none"}, the recruitment model parameter
   (\code{m}) set to \code{NA} and the numbers of study participants recruited
   and with outcome data at each of the interims set to \code{ninterims}.}
 \item{idata}{A list of same structure as for \code{\link{gsearlyModel}} with
   the  correlation model type (\code{cmodel$type}) set to \code{"none"} and the
   parameter (\code{cmodel$rho}) set to \code{NA}, if either \code{"uniform"} or
   \code{"exponential"} are not selected.}
 \item{power}{A list of same structure as for \code{\link{gsearlyModel}}. In
   addition for designs based on fixed numbers of participants at interim, where
   \code{n} is unset, the minimum and maximum attainable power
   (\code{rangepow}).}
}
\seealso{
 \code{\link{gsearlyModel}}
}
\examples{

 # For 90 percent power (pow), a call to gsearlyModel provides a feasible design
 fp <- c(0.0000,0.0010,0.0250)
 tn <- c(0.2400,0.7200,0.9750)
 modeldesign <- gsearlyModel(rmodel="dilin", trecruit=36, s=3, tfu=c(3,6,12),
                   tinterims=c(18,30), pow=0.9, vphi=0.5, m=2,
                   cmodel="uniform", sd=20, rho=0.5, theta=8, fp=fp, tn=tn)
 modeldesign

 # This design can be replicated using gsearlyUser
 n <- modeldesign$rdata$n["total"]
 ninterims <- modeldesign$rdata$interims
 cmodel <- modeldesign$idata$cmodel$corrmat
 userdesign <- gsearlyUser(trecruit=36, s=3, tfu=c(3,6,12), tinterims=c(18,30),
        ninterims=ninterims, n=n, vphi=0.5, cmodel=cmodel,
        sd=20, theta=8, fp=fp, tn=tn)
 userdesign

 # Expected numbers of participants at interim analyses
 modeldesign$rdata$interims
 userdesign$rdata$interims

 # Information at these interims and final analysis
 modeldesign$idata$interims
 userdesign$idata$interims

 # Upper and lower stopping boundaries and probabilities
 rbind(modeldesign$power$lowerror, modeldesign$power$upperror)
 rbind(userdesign$power$lowerror, userdesign$power$upperror)

 # Change correlation matrix and interim numbers
 cmodel <- matrix(c(1,0.2,0.1, 0.2,1,0.1, 0.1,0.1,1), nrow=3, byrow=TRUE)
 ninterims <- matrix(c(130,110,90,45, 200,175,160,120), nrow=2, byrow=TRUE)
 # For 90 percent power (pow), a call to gsearlyUser provides a feasible design
 nuserdesign <- gsearlyUser(trecruit=36, s=3, tfu=c(3,6,12), tinterims=c(18,30),
        ninterims=ninterims, vphi=0.5, pow=0.9, cmodel=cmodel,
        sd=20, theta=8, fp=fp, tn=tn)
 nuserdesign

}
