% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gscramble2plink.R
\name{gscramble2plink}
\alias{gscramble2plink}
\title{Write 'gscramble' I_meta, M_meta, and Geno to a plink file}
\usage{
gscramble2plink(I_meta, M_meta, Geno, prefix = tempfile())
}
\arguments{
\item{I_meta}{a tibble of individual meta data
with at least the columns of \code{group} and \code{indiv}.}

\item{M_meta}{a tibble of marker meta data with at least the columns
of \code{chrom}, \code{pos}, and \code{variant_id}.}

\item{Geno}{a character matrix of genotypes.  Num-indivs rows and
num-markers * 2 columns, with missing denoted denoted by NA.}

\item{prefix}{the file path and prefix into which to write out the files}
}
\value{
Returns TRUE if successful.
}
\description{
Writes genetic and individual information in 'gscramble's
I_meta, M_meta, and Geno like objects into a uncompressed plink
\code{.ped} and \code{.map} files.
}
\examples{
gscramble2plink(I_meta, M_meta, Geno)
}
