% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drop-segs-down-gsp.R
\name{drop_segs_down_gsp}
\alias{drop_segs_down_gsp}
\title{High level function for dropping segments down a GSP}
\usage{
drop_segs_down_gsp(GSP, RR, Reps)
}
\arguments{
\item{GSP}{the pedigree to use for the simulation, in the format of
the package data \code{\link{GSP}}.}

\item{RR}{the recombination rates in the format of the package data
\code{\link{RecRates}}}

\item{Reps}{the number of times to do the simulation.  Different replicates
are denoted by the index column in the output tibble.}
}
\value{
The output from this function is a tibble.  Each row represents one segment of genetic
material amongst the sampled individuals from the genomic permutation pedigrees. The columns give
information about the provenance and destination of that segment as follows.
Each segment exists in one of the samples (\code{samp_index}) from a sampled individual
with a \code{ped_sample_id}
in a given \code{samp_index} within the individual.  Further, it is on one of two gametes
(\code{gamete_index}) that segregated into the individual, and it came from a certain founding
population (\code{pop_origin}).
And, of course, the segment occupies the space from \code{start} to \code{end} on a chromosome \code{chrom}.
Finally, the index of the founder haplotype on the given gpp that this segement descended from is
given in \code{rs_founder_haplotype} which is short for "rep-specific founder haplotype". This final
piece of information is crucial for segregating variation from the individuals in the \code{Geno} file
onto these segments. The \code{gamete_segments} column is a list column with duplicated entries for
each chromosome in an individual.
}
\description{
This one asks for the number of reps to do, and it also
automatically does it over chromosomes and returns the results
in a nice tidy tibble.
}
\examples{
simSegs <- drop_segs_down_gsp(GSP, RecRates, 4)


}
