% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.blkmat.R
\name{plot.blkmat}
\alias{plot.blkmat}
\title{Plot Function for Block-Structured Precision Matrices
(Visualize a Matrix with Group Boundaries)}
\usage{
\method{plot}{blkmat}(x, colors = NULL, ...)
}
\arguments{
\item{x}{An object inheriting from S3 class \code{"blkmat"}, typically
returned by \code{\link[grasps]{grasps}}, \code{\link[grasps]{gen_prec_sbm}}
or \code{\link[grasps]{sparsify_block_banded}}.}

\item{colors}{A vector of colors specifying an n-color gradient scale for
the fill aesthetics.}

\item{...}{Additional arguments passed to \code{\link[ggplot2]{ggplot}}.}
}
\value{
A heatmap of class \code{ggplot} showing the matrix entries.
Dashed lines indicate group boundaries.
The plot title also reports matrix dimension and sparsity.
}
\description{
Visualize a precision matrix as a heatmap with dashed boundary lines
separating group blocks. This function is shared by objects returned from
\code{\link[grasps]{grasps}}, \code{\link[grasps]{gen_prec_sbm}}, and
\code{\link[grasps]{sparsify_block_banded}}, all of which inherit from
the S3 class \code{"blkmat"}.
}
\examples{
library(grasps)

## reproducibility for everything
set.seed(1234)

## block-structured precision matrix based on SBM
sim <- gen_prec_sbm(d = 100, K = 10,
                    within.prob = 0.2, between.prob = 0.05,
                    weight.dists = list("gamma", "unif"),
                    weight.paras = list(c(shape = 100, scale = 10),
                                        c(min = 0, max = 5)),
                    cond.target = 100)

## visualization
plot(sim)
}
