% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/teststatistics.R
\name{BG}
\alias{BG}
\title{The Baringhaus-Gaigall test statistic}
\usage{
BG(data)
}
\arguments{
\item{data}{a vector of positive numbers.}
}
\value{
value of the test statistic.
}
\description{
This function computes the test statistic of the goodness-of-fit test for the inverse Gaussian family due to Baringhaus and Gaigall (2015).
}
\details{
The test statistic of the Baringhaus-Gaigall test is defined as: 
\deqn{BG_{n} = \frac{n}{(n(n-1))^5} \sum_{\mu, \nu = 1, \mu \neq \nu}^{n} \left( N_1(\mu, \nu)N_4(\mu, \nu) - N_2(\mu, \nu)N_3(\mu, \nu) \right)^2,}
where
\deqn{N_1(\mu, \nu) = \sum_{i,j = 1, i \neq j}^{n} \mathbf{1} \left\{ \tilde{Y}_{i,j} \leq \tilde{Y}_{\mu, \nu}, \tilde{Z}_{i,j} \leq \tilde{Z}_{\mu, \nu} \right\},}
\deqn{N_2(\mu, \nu) = \sum_{i,j = 1, i \neq j}^{n} \mathbf{1} \left\{ \tilde{Y}_{i,j} \leq \tilde{Y}_{\mu, \nu}, \tilde{Z}_{i,j} > \tilde{Z}_{\mu, \nu} \right\},}
\deqn{N_3(\mu, \nu) = \sum_{i,j = 1, i \neq j}^{n} \mathbf{1} \left\{ \tilde{Y}_{i,j} > \tilde{Y}_{\mu, \nu}, \tilde{Z}_{i,j} \leq \tilde{Z}_{\mu, \nu} \right\},}
\deqn{N_4(\mu, \nu) = \sum_{i,j = 1, i \neq j}^{n} \mathbf{1} \left\{ \tilde{Y}_{i,j} > \tilde{Y}_{\mu, \nu}, \tilde{Z}_{i,j} > \tilde{Z}_{\mu, \nu} \right\},}
with \eqn{\mathbf{1}} being the indicator function.
Let \eqn{f(X_i,X_j) = (X_i + X_j)/2} and \eqn{g(X_i,X_j) = (X_i^{-1} + X_j^{-1})/2 - f(X_i,X_j)^{-1}}, with \eqn{X_1,...,X_n} positive, independent and identically distributed random variables with finite moments \eqn{\mathbb{E}[X_1^2]} and \eqn{\mathbb{E}[X_1^{-1}]}. 
Then \eqn{(\tilde{Y}_{i,j}, \tilde{Z}_{i,j}) = (f(X_i,X_j), g(X_i,X_j)), 1 \leq i,j \leq n, i \neq j}. Note that \eqn{\tilde{Y}_{i,j}} and \eqn{\tilde{Z}_{i,j}} are independent if, and only if \eqn{X_1,...,X_n} are realized from an inverse Gaussian distribution.
}
\examples{
BG(rmutil::rinvgauss(20,2,1))

}
\references{
Baringhaus, L.  Gaigall, D. (2015). "On an independence test approach to the goodness-of-fit problem", Journal of Multivariate Analysis, 140, 193-208. \doi{https://doi.org/10.1016/j.jmva.2015.05.013}
}
