% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Anamorphosis.R
\name{sphTrans}
\alias{sphTrans}
\alias{sphTrans.default}
\title{Spherifying transform
Compute a transformation that spherifies a certain data set}
\usage{
sphTrans(Y, ...)

\method{sphTrans}{default}(Y, weights = NULL, p = 1:ncol(Y), ...)
}
\arguments{
\item{Y}{data set defining the spherifization}

\item{...}{extra arguments for generic functionality}

\item{weights}{weights to incorporate in the compuations, length=nrow(Y)}

\item{p}{dimensions to be considered structural (useful for filtering noise)}
}
\value{
a function with arguments \code{(x, inv=FALSE)}, where \code{x} will be the
data to apply the transformation to, and \code{inv=FALSE} will indicate if the direct
or the inverse transformation is desired.
This function applied to the same data returns a translated, rotated and scaled, so that
the new scores are centered, have variance 1, and no correlation.
}
\description{
Spherifying transform
Compute a transformation that spherifies a certain data set
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Spherifying transform
}}

\examples{
library(compositions)
data("jura", package="gstat")
Y = acomp(jura.pred[,c(10,12,13)])
oldpar = par(mfrow = c(1,1))
plot(Y)
sph = sphTrans(Y)
class(sph)
z = sph(Y)
plot(z)
par(oldpar)
cor(cbind(z, ilr(Y)))
colMeans(cbind(z, ilr(Y)))
}
\seealso{
ana, anaBackward, sphTrans
}
\author{
K. Gerald van den Boogaart, Raimon Tolosana-Delgado
}
