% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gmSpatialModel.R
\docType{class}
\name{gmSpatialModel-class}
\alias{gmSpatialModel-class}
\alias{variogram,gmSpatialModel-method}
\alias{logratioVariogram,gmSpatialModel-method}
\alias{as.gstat,gmSpatialModel-method}
\title{Conditional spatial model data container}
\usage{
\S4method{variogram}{gmSpatialModel}(object, methodPars = NULL, ...)

\S4method{logratioVariogram}{gmSpatialModel}(data, ..., azimuth = 0, azimuth.tol = 180/length(azimuth))

\S4method{as.gstat}{gmSpatialModel}(object, ...)
}
\arguments{
\item{object}{a gmSpatialModel object containing spatial data.}

\item{methodPars}{(currently ignored)}

\item{...}{further parameters to \code{\link[gstat:variogram]{gstat::variogram()}}}

\item{data}{the data container (see \linkS4class{gmSpatialModel} for details)}

\item{azimuth}{which direction, or directions, are desired (in case of directional variogram)}

\item{azimuth.tol}{which tolerance sould be used for directional variograms?}
}
\value{
You will seldom create the spatial model directly. Use instead the creators \verb{make.gm*} linked below
}
\description{
This class is devised to contain a conditional spatial model, with: some conditioning data
(a \code{\link[sp:SpatialPoints]{sp::SpatialPointsDataFrame()}}), an unconditional geospatial model (a structure with e.g.
a training image; or the information defining a Gaussian random field); and eventually some
extra method parameters. The class extends \code{\link[sp:SpatialPoints]{sp::SpatialPointsDataFrame()}} and has therefore its slots,
plus \code{model} (for the unconditional model) and \code{parameters} (for the extra method information)
}
\section{Methods (by generic)}{
\itemize{
\item \code{variogram}: Compute a variogram, see \code{\link[=variogram_gmSpatialModel]{variogram_gmSpatialModel()}} and \code{\link[=variogram]{variogram()}} for details

\item \code{logratioVariogram}: S4 wrapper method around \code{\link[=logratioVariogram]{logratioVariogram()}} for \code{gmSpatialModel}
objects

\item \code{as.gstat}: convert from gmSpatialModel to gstat; see \code{\link[=as.gstat]{as.gstat()}}
for details
}}

\section{Slots}{

\describe{
\item{\code{data}}{a data.frame (or class extending it) containing the conditional data}

\item{\code{coords}}{a matrix or dataframe of 2-3 columns containing the sampling locations of the conditional data}

\item{\code{coords.nrs}}{see \code{\link[sp:SpatialPoints]{sp::SpatialPointsDataFrame()}}}

\item{\code{bbox}}{see \code{\link[sp:SpatialPoints]{sp::SpatialPointsDataFrame()}}}

\item{\code{proj4string}}{see \code{\link[sp:SpatialPoints]{sp::SpatialPointsDataFrame()}}}

\item{\code{model}}{gmUnconditionalSpatialModel. Some unconditional geospatial model. It can be NULL.}

\item{\code{parameters}}{gmSpatialMethodParameters. Some method parameters. It can be NULL}
}}

\examples{
data("jura", package="gstat")
library(sp)
X = jura.pred[,1:2]
Zc = jura.pred[,7:13]
spdf = sp::SpatialPointsDataFrame(coords=X, data=Zc)
new("gmSpatialModel", spdf)
make.gmCompositionalGaussianSpatialModel(data=Zc, coords=X, V="alr")
}
\seealso{
Other gmSpatialModel: 
\code{\link{Predict}()},
\code{\link{as.gmSpatialModel}()},
\code{\link{make.gmCompositionalGaussianSpatialModel}()},
\code{\link{make.gmCompositionalMPSSpatialModel}()},
\code{\link{make.gmMultivariateGaussianSpatialModel}()}
}
\concept{gmSpatialModel}
