% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layer-spatial-terra.R
\docType{data}
\name{layer_spatial.SpatRaster}
\alias{layer_spatial.SpatRaster}
\alias{annotation_spatial.SpatRaster}
\alias{StatSpatRaster}
\alias{StatSpatRasterAnnotation}
\alias{StatSpatRasterDf}
\alias{GeomSpatRaster}
\title{Spatial ggplot2 layer for SpatRaster objects}
\format{
An object of class \code{StatSpatialRaster} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 3.

An object of class \code{StatSpatRaster} (inherits from \code{StatSpatialRaster}, \code{Stat}, \code{ggproto}, \code{gg}) of length 3.

An object of class \code{StatSpatRasterDf} (inherits from \code{Stat}, \code{ggproto}, \code{gg}) of length 5.

An object of class \code{GeomSpatRaster} (inherits from \code{Geom}, \code{ggproto}, \code{gg}) of length 5.
}
\usage{
\method{layer_spatial}{SpatRaster}(
  data,
  mapping = NULL,
  interpolate = NULL,
  is_annotation = FALSE,
  lazy = FALSE,
  dpi = 150,
  ...
)

\method{annotation_spatial}{SpatRaster}(data, mapping = NULL, interpolate = NULL, ...)

StatSpatRaster

StatSpatRasterAnnotation

StatSpatRasterDf

GeomSpatRaster
}
\arguments{
\item{data}{A SpatRaster object created with \code{\link[terra:rast]{terra::rast()}}.}

\item{mapping}{Currently, only RGB or RGBA rasters are supported. In the future, one may be able to
map specific bands to the fill and alpha aesthetics.}

\item{interpolate}{Interpolate resampling for rendered raster image}

\item{is_annotation}{Lets raster exist without modifying scales}

\item{lazy}{Delay projection and resample of raster until the plot is being rendered}

\item{dpi}{if lazy = TRUE, the dpi to which the raster should be resampled}

\item{...}{Passed to other methods}
}
\value{
A ggplot2 layer
}
\description{
This is intended for use with RGB(A) rasters (e.g., georeferenced imagery
or photos). To work with bands as if they were columns, use \code{\link[=df_spatial]{df_spatial()}}
and \code{\link[ggplot2:geom_tile]{ggplot2::geom_raster()}}.
}
\examples{
\donttest{

library(ggplot2)
load_longlake_data(
  which = c(
    "longlake_osm",
    "longlake_depth_raster"
  ),
  raster_format = "terra"
)
ggplot() +
  layer_spatial(longlake_osm)

ggplot() +
  layer_spatial(longlake_depth_raster) +
  scale_fill_continuous(
    na.value = NA,
    type = "viridis"
  )
}
}
\keyword{datasets}
