% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{geom_normalviolin}
\alias{geom_normalviolin}
\title{Creates normal violins with specified means and standard deviations}
\usage{
geom_normalviolin(
  mapping = NULL,
  data = NULL,
  mu = NULL,
  sigma = NULL,
  nsigma = 4,
  p_tail = 0,
  p_lower_tail = p_tail/2,
  p_upper_tail = p_tail/2,
  tail_fill = "black",
  tail_alpha = 0.4,
  width = 0.6,
  upper_limit = NA,
  lower_limit = NA,
  face_left = TRUE,
  face_right = TRUE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by ggplot2::aes().}

\item{data}{The data to be displayed in this layer}

\item{mu}{A vector of means}

\item{sigma}{A vector of standard deviations}

\item{nsigma}{The number of standard deviations each violin should extend}

\item{p_tail}{The 2-tailed proportion that should be highlighted.
Can be overridden with p_lower_tail and/or p_upper_tail}

\item{p_lower_tail}{The proportion of the distribution that should be
highlighted in the lower tail. Defaults to half of `p_tail`.}

\item{p_upper_tail}{The proportion of the distribution that should be
highlighted in the upper tail. Defaults to half of `p_tail`.}

\item{tail_fill}{fill color for tails}

\item{tail_alpha}{alpha value for tails}

\item{width}{Width of normal violin}

\item{upper_limit}{upper limit for polygons. Needed in case setting
limits in scale_y_continuous or ylim distorts the polygons.}

\item{lower_limit}{lower limit for polygons. Needed in case setting
limits in scale_y_continuous or ylim distorts the polygons.}

\item{face_left}{Display left half of violins. Defaults to `TRUE`}

\item{face_right}{Display right half of violins. Defaults to `TRUE`}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If `FALSE`, overrides the default aesthetics,
rather than combining with them.}

\item{...}{Other arguments passed to `ggplot2::layer`}
}
\value{
A ggplot2 layer that can be added to a plot created with
  [ggplot()][ggplot2::ggplot()].
}
\description{
Creates normal violins with specified means and standard deviations
}
\section{Aesthetics}{

\code{geom_normviolin} understands the following aesthetics
(required aesthetics are in bold):
\itemize{
  \item \strong{x}
  \item \strong{mu} (mean of the normal distribution)
  \item \strong{sigma} (standard deviation of the normal distribution)
  \item width (width of violin)
  \item nsigma (number of standard deviations to which the violins extend)
  \item p_tail (2-tailed proportion of tails highlighted)
  \item p_upper_tail (proportion of upper tails highlighted)
  \item p_lower_tail (proportion of lower tails highlighted)
  \item face_left (display left half of violin?)
  \item face_right (display right half of violin?)
  \item color (of lines)
  \item fill
  \item alpha (of fills)
  \item group
  \item linetype
  \item linewidth
}
}

\examples{
library(ggplot2)
d <- data.frame(
  dist = c("A", "B"),
  dist_mean = c(80, 90),
  dist_sd = c(15, 10))

ggplot(data = d, aes(
  x = dist,
  mu = dist_mean,
  sigma = dist_sd,
  fill = dist)) +
  geom_normalviolin() +
  theme(legend.position = "none")
}
