% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_sf_inset.R, R/stat_sf_inset.R
\docType{data}
\name{geom_sf_inset}
\alias{geom_sf_inset}
\alias{GeomSfInset}
\alias{stat_sf_inset}
\alias{StatSfInset}
\title{Visualise sf objects with insets}
\usage{
geom_sf_inset(
  mapping = ggplot2::aes(),
  data = NULL,
  stat = "sf_inset",
  position = "identity",
  ...,
  inset = NA,
  map_base = "normal",
  map_inset = "auto",
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)

stat_sf_inset(
  mapping = ggplot2::aes(),
  data = NULL,
  geom = "sf_inset",
  position = "identity",
  ...,
  inset = NA,
  na.rm = TRUE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping, data, stat, geom, position, na.rm, show.legend, inherit.aes, ...}{See \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}.}

\item{inset}{Inset configuration; see \code{\link[=configure_inset]{configure_inset()}}.
If \code{NA} (the default), this is inherited from the coord (see \code{\link[=coord_sf_inset]{coord_sf_inset()}}).}

\item{map_base}{Controls the layer with the base map. Possible values are
\code{"normal"} to create a layer as though the inset were not specified,
\code{"clip"} to create a layer with the inset viewport cut out, and
\code{"none"} to prevent the insertion of a layer for the base map.}

\item{map_inset}{Controls the layer with the inset map. Possible values are
\code{"auto"} to choose the behaviour based on whether \code{inset} is specified,
\code{"normal"} to create a layer with the viewport cut out and transformed, and
\code{"none"} to prevent the insertion of a layer for the viewport map.}
}
\value{
A ggplot layer similar to \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}} but transformed according to the
inset configuration.
}
\description{
These geoms are wrappers around \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}} and its relatives that
assist with creating map insets.
In many cases all that is needed is to use \code{\link[=coord_sf_inset]{coord_sf_inset()}} with \code{\link[=configure_inset]{configure_inset()}}
to configure the location and transformation of the inset, and then replace the
sf-related geoms with their \verb{_inset} counterparts.
Use \code{\link[=geom_inset_frame]{geom_inset_frame()}} to add a frame around the inset that connects it to the main map.
}
\details{
Internally this works by creating two layers: one for the base map, and one
for the inset. These can be separately controlled by the \code{map_base} and
\code{map_inset} parameters. If \code{inset} is not specified, this geom will instead
behave like \code{\link[ggplot2:ggsf]{ggplot2::geom_sf()}}.

When an inset is configured, the default creates both base and inset layers
using the same aesthetic mapping and params:

\if{html}{\out{<div class="sourceCode">}}\preformatted{geom_sf_inset(...)
}\if{html}{\out{</div>}}

You can alternatively specify the two layers separately:

\if{html}{\out{<div class="sourceCode">}}\preformatted{# draw the base map only (both versions are equivalent):
geom_sf(...)
geom_sf_inset(..., map_inset = "none")

# separately, draw the inset map only:
geom_sf_inset(..., map_base = "none")
}\if{html}{\out{</div>}}

\code{stat_sf_inset()} works the same \code{\link[ggplot2:ggsf]{ggplot2::stat_sf()}} except that it also
expands the axis limits to account for the inset area.
}
\examples{
library(ggplot2)

nc <- sf::st_read(system.file("shape/nc.shp", package = "sf"), quiet = TRUE)

ggplot(nc) +
  geom_sf_inset(aes(fill = AREA)) +
  geom_inset_frame() +
  coord_sf_inset(configure_inset(
    shape_circle(
      centre = sf::st_sfc(sf::st_point(c(-80, 35.5)), crs = sf::st_crs(nc)),
      radius = 50
    ),
    scale = 1.5, translation = c(-50, -140), units = "mi"
  ))
}
\keyword{datasets}
