% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{read_glycan}
\alias{read_glycan}
\title{Read Glycan Data}
\usage{
read_glycan(x, format = "iupac")
}
\arguments{
\item{x}{A character string representing the glycan structure.}

\item{format}{The format of the string. Currently only "iupac" is supported.}
}
\value{
An `igraph` object representing the glycan structure.
}
\description{
Parses a glycan string (IUPAC condensed format) and returns a graph object.
}
\examples{
s <- "Neu5Ac(a2-3)Gal(b1-4)GlcNAc(b1-2)Man(a1-3)Man(b1-4)GlcNAc(b1-4)GlcNAc"
g <- read_glycan(s)
}
