% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colourspaces.R
\name{as_colourspace}
\alias{as_colourspace}
\title{Collect channels into a single layer of a specific colourspace}
\usage{
as_colourspace(
  ...,
  colourspace = "sRGB",
  auto_opacity = TRUE,
  id = NULL,
  include = is.null(id)
)
}
\arguments{
\item{...}{A range of layers to combine. If there are no channel spec set the
luminosity will be used}

\item{colourspace}{Which colourspace should the provided colour channels be
interpreted as coming from.}

\item{auto_opacity}{Should the opacity be derived from the input layers or
taken from a provided alpha channel}

\item{id}{A string identifying this layer for later use}

\item{include}{Should the layer itself be included in the graphic}
}
\value{
A list of \code{Layer} objects
}
\description{
If you need to work on single channels one by one you can use the different
\link[=ch_red]{ch_*()} selectors. If the result needs to be combined again into a
colour layer you can use \code{as_colourspace} and pass in the required channels
to make up the colourspace. By default the alpha channel will be created as
the combination of the alpha channels from the provided channel layers.
Alternatively you can set \code{auto_opacity = FALSE} and provide one additional
channel which will then be used as alpha.
}
\examples{
library(ggplot2)

segments <- data.frame(
  x = runif(300),
  y = runif(300),
  xend = runif(300),
  yend = runif(300)
)

# We use 'white' as that is the maximum value in all channels
ggplot(mapping = aes(x, y, xend = xend, yend = yend)) +
  as_colourspace(
    geom_segment(data = segments[1:100,], colour = 'white'),
    geom_segment(data = segments[101:200,], colour = 'white'),
    geom_segment(data = segments[201:300,], colour = 'white'),
    colourspace = 'CMY'
  )

}
\seealso{
Other layer references: 
\code{\link{as_group}()},
\code{\link{as_reference}()}
}
\concept{layer references}
