% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sumlogprior}
\alias{sumlogprior}
\title{Sum of Log Prior Densities for a Joint Prior Distribution}
\usage{
sumlogprior(p_prior_r, parameters_r)
}
\arguments{
\item{p_prior_r}{A list of prior specifications. Each element is itself a 
list specifying the prior for one parameter, typically created by 
\code{\link{BuildPrior}}. Each sublist should contain:
  \itemize{
    \item \code{p0}: First parameter of the distribution (e.g., mean).
    \item \code{p1}: Second parameter (e.g., standard deviation or shape).
    \item \code{lower}: Lower bound for the parameter (if applicable).
    \item \code{upper}: Upper bound (if applicable).
    \item \code{dist}: Character string specifying the distribution type.
    \item \code{log_p}: Logical; should be \code{TRUE} for log-density computation.
  }}

\item{parameters_r}{A numeric vector of parameter values at which to
evaluate the prior. Must be the same length as \code{p_prior_r}.}
}
\value{
A single numeric value: the sum of log-densities evaluated at the given 
parameter vector.
}
\description{
Computes the sum of log-densities for a vector of parameters, based on
their respective prior distribution specifications. This function is used
in Bayesian computations where the joint prior is the product of 
independent priors—thus, the log of the joint prior is the sum of
log-densities.
}
\details{
This function performs the following steps:
\itemize{
  \item Iterates over each parameter and its associated prior specification
  \item Evaluates the log-density for each parameter
  \item Sums all log-densities to compute the joint log prior
}

This is useful, for example, in computing the log-posterior of hierarchical 
Bayesian models where priors are assumed to be independent.
}
\examples{
p0 <- c(A = 0.15, B = 0.45, mean_v = 2.25, sd_v = 0.15, t0 = 0.2)
tnorm_prior <- BuildPrior(
    p0 = p0,
    p1 = rep(1, 5),
    lower = rep(0, 5),
    upper = rep(NA, 5),
    dist = rep("tnorm", 5),
    log_p = rep(TRUE, 5)
)

npar <- length(tnorm_prior)
theta <- runif(npar, 0, 10)
result <- sumlogprior(p_prior_r = tnorm_prior, parameters_r = theta)
print(result)

}
