% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\docType{package}
\name{ggdmcModel}
\alias{ggdmcModel-package}
\alias{ggdmcModel}
\title{Model Builders for 'ggdmc' Package}
\description{
A suite of tools for specifying and examining experimental
designs related to choice response time models (e.g.,
the Diffusion Decision Model). This package allows users to
define how experimental factors influence one or more model
parameters using R-style formula syntax, while also
checking the logical consistency of these associations.
Additionally, it integrates with the 'ggdmc' package, which
employs Differential Evolution Markov Chain Monte Carlo
(DE-MCMC) sampling to optimise model parameters. For
further details on the model-building approach, see
Heathcote, Lin, Reynolds, Strickland, Gretton, and
Matzke (2019) <doi:10.3758/s13428-018-1067-y>.
}
\references{
Heathcote, A., Lin, Y.-S., Reynolds, A., Strickland, L., Gretton, M. &
Matzke, D., (2019). Dynamic model of choice.
\emph{Behavior Research Methods}.
https://doi.org/10.3758/s13428-018-1067-y.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/yxlin/ggdmcModel}
}

}
\author{
Yi-Shin Lin <yishinlin001@gmail.com>
}
\keyword{internal}
\keyword{package}
