% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_blur_dots.R
\name{blur}
\alias{blur}
\alias{blur_gaussian}
\alias{blur_interval}
\title{Blur functions for blurry dot plots}
\usage{
blur_gaussian(x, r, sd)

blur_interval(x, r, sd, .width = 0.95)
}
\arguments{
\item{x}{<\link{numeric}> Vector of positive distances from the center of the dot
(assumed to be 0) to evaluate blur function at.}

\item{r}{<scalar \link{numeric}> Radius of the dot that is being blurred.}

\item{sd}{<scalar \link{numeric}> Standard deviation of the dot that is being blurred.}

\item{.width}{<scalar \link{numeric}> For \code{blur_interval()}, a probability giving the width of
the interval.}
}
\value{
A vector with the same length as \code{x} giving the opacity of the radial
gradient representing the dot at each \code{x} value.
}
\description{
Methods for constructing blurs, as used in the \code{blur} argument to
\code{\link[=geom_blur_dots]{geom_blur_dots()}} or \code{\link[=stat_mcse_dots]{stat_mcse_dots()}}.

Supports \link[=auto_partial]{automatic partial function application} with
\link[=waiver]{waived arguments}.
}
\details{
These functions are passed \code{x}, \code{r}, and \code{sd} when \code{\link[=geom_blur_dots]{geom_blur_dots()}}
draws in order to create a radial gradient representing each dot in the
dotplot. They return values between \code{0} and \code{1} giving the opacity of the
dot at each value of \code{x}.

\code{blur_gaussian()} creates a dot with radius \code{r} that has a Gaussian blur with
standard deviation \code{sd} applied to it. It does this by calculating
\eqn{\alpha(x; r, \sigma)}, the opacity at distance \eqn{x} from the center
of a dot with radius \eqn{r} that has had a Gaussian blur with standard
deviation \eqn{\sigma} = \code{sd} applied to it:

\deqn{
\alpha(x; r, \sigma) = \Phi \left(\frac{x + r}{\sigma} \right) -
  \Phi \left(\frac{x - r}{\sigma} \right)
}

\code{blur_interval()} creates an interval-type representation around the
dot at 50\% opacity, where the interval is a Gaussian quantile interval with
mass equal to \code{.width} and standard deviation \code{sd}.
}
\examples{
# see examples in geom_blur_dots()
}
\seealso{
\code{\link[=geom_blur_dots]{geom_blur_dots()}} and \code{\link[=stat_mcse_dots]{stat_mcse_dots()}} for geometries making use of
\code{blur} functions.
}
