% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggalignment.R
\name{ggalignment}
\alias{ggalignment}
\title{Creates a D&D alignment chart}
\usage{
ggalignment(
  alignment,
  line_type = "dashed",
  line_color = "black",
  font_family = NULL,
  font_color = "black",
  font_size = NULL,
  background_color = "white",
  background_border = NA,
  max_images_per_dim = 2,
  max_image_dim = "width"
)
}
\arguments{
\item{alignment}{a data.frame containing the data to be plotted, requiring
columns \code{img} (for image path) and \code{alignment}, and optionally \code{x} and \code{y}
specifying the coordinates for each image, where each box has coordinate limits
from -1 to 1 in both axes.}

\item{line_type}{the linetype for the box borders, which follows the ggplot2
allowable values for linetype for geom_rect() (e.g. blank, solid,
dashed, dotted, dotdash, longdash, twodash)}

\item{line_color}{the color for the bounding boxes of the alignments, defaults
to black, and must be a named color such as "black"}

\item{font_family}{the font family to be used on the alignment labels}

\item{font_color}{the font color to be used on the alignment labels}

\item{font_size}{the size of the font used on the alignment labels}

\item{background_color}{the background color for the entire plot, defaults to
white and must be a named color such as "white"}

\item{background_border}{the color of the solid-line bounding box on the entire
plot, defaults to NA and must be either NA or a named color such as "black"}

\item{max_images_per_dim}{numeric representing the number of images that
should fit in a single fact -- for example, if you want an image to take up
half the width of the fact, use max_images_per_dim = 2}

\item{max_image_dim}{one of "width" or "height", representing if the max_images_per_dim
should count by width or height in the facet}
}
\value{
a ggplot containing the alignment chart
}
\description{
The primary function of the package, this function creates a D&D alignment chart from a dataframe with img, x, and y columns!
}
\examples{
\donttest{
  align_cats <- example_cats()
  ggalignment(alignment = align_cats)
}
}
