% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_font.R
\name{use_font}
\alias{use_font}
\title{Use a downloaded font in Shiny or Markdown}
\usage{
use_font(id, css_path, selector = "body", css = NULL)
}
\arguments{
\item{id}{Id of the font downloaded.}

\item{css_path}{Path to CSS generated by \code{\link{setup_font}}.}

\item{selector}{CSS selector for which to use the font,
usually an HTML tag, default to \code{"body"} (all document).}

\item{css}{CSS variables needed to use font, normally this should be automatic.}
}
\value{
an HTML tag with an HTML dependency (\code{\link[htmltools]{htmlDependency}}).
}
\description{
Use a downloaded font in Shiny or Markdown
}
\examples{

if (interactive()) {
  library(gfonts)

  # Here we use a temp directory
  # but in Shiny, it can be www/ folder
  directory <- tempfile()
  dir.create(directory)

  # Setup a font (only needed once)
  setup_font(
    id = "dancing-script",
    output_dir = directory
  )

  library(shiny)

  ui <- fluidPage(

    # Use font
    use_font(
      id = "dancing-script",
      css_path = file.path(directory, "css/dancing-script.css")
    ),

    tags$p(
      paste(letters, collapse = "")
    ),
    tags$p(
      paste(LETTERS, collapse = "")
    ),
    tags$p(
      style = "font-weight: bold;",
      paste(letters, collapse = "")
    ),
    tags$p(
      style = "font-weight: bold;",
      paste(LETTERS, collapse = "")
    ),
    tags$p(
      style = "font-style: italic;",
      paste(letters, collapse = "")
    ),
    tags$p(
      style = "font-style: italic;",
      paste(LETTERS, collapse = "")
    ),
    tags$h1("First level title"),
    tags$h2("Second level title"),
    tags$h3("Third level title"),
    tags$h4("Fourth level title"),
    tags$h5("Fifth level title"),
    tags$h6("Sixth level title")
  )

  server <- function(input, output, session) {

  }
  shinyApp(ui, server)
}











}
