% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_npht}
\alias{plot_npht}
\title{Plot output from nph_traj}
\usage{
plot_npht(
  data,
  KM = TRUE,
  censor = TRUE,
  recruitment = TRUE,
  events = TRUE,
  logHR = TRUE,
  power = TRUE,
  include_frontier = TRUE,
  include_RMST = TRUE,
  include_landmark = TRUE,
  alpha1 = 0.025,
  legend_position = c("top_left", "top_right", "bottom_right")
)
}
\arguments{
\item{data}{Full output list from nph_traj()}

\item{KM}{Boolean to include KM plot (Default = TRUE)}

\item{censor}{Boolean to include censoring plot (Default = TRUE)}

\item{recruitment}{Boolean to include recruitment plot (Default = TRUE)}

\item{events}{Boolean to include events plot (Default = TRUE)}

\item{logHR}{Boolean to include log(HR) plot (Default = TRUE)}

\item{power}{Boolean to include power plot (Default = TRUE)}

\item{include_frontier}{Boolean to include frontier power curve in power plot (Default = TRUE)}

\item{include_RMST}{Boolean to include RMST power curve in power plot if available (Default = TRUE)}

\item{include_landmark}{Boolean to include landmark power curve in power plot if available (Default = TRUE)}

\item{alpha1}{One-sided alpha to use for estimation of log(HR) confidence intervals (Default = 0.025)}

\item{legend_position}{String with any of "top_left","top_right" or "bottom_right", corresponding to legend position in power plot. Default is "top_left".}
}
\value{
Returns NULL
}
\description{
This function plots the output from nph_traj().\cr
By default, it produces 6 plots:
\itemize{
 \item{"KM plot"}{ Kaplan Meier plot for events. This is in patient time.}
 \item{"Censoring plot"}{ Plot of CDFs for censoring functions. This is in patient time.}
 \item{"Recruitment plot"}{ Number of patients expected to have been recruited over time. This is in trial time.}
 \item{"Event plot"}{ Total number of events expected to occur over time. This is in trial time.}
 \item{"log(HR) plot"}{ Expected log(HR), with expected confidence interval, over time. This is in trial time.}
 \item{"Power plot"}{ Expected power over time for various methods. This is in trial time.}
}
Plots may be omitted via arguments.\cr
All calculated powers automatically plotted unless specified otherwise.\cr
}
\examples{
trial <- nph_traj(Weibull(100,1),Weibull(70,1),rcurve=LinearR(12,100,100),RMST=20,
  landmark=20,max_assessment=30)

plot_npht(trial)
plot_npht(data=trial,KM=FALSE,censor=FALSE,recruitment=FALSE)
plot_npht(data=trial,KM=FALSE,censor=FALSE,recruitment=FALSE,events=FALSE,logHR=FALSE,
include_frontier=FALSE, include_RMST=FALSE,include_landmark=FALSE,legend_position="top_right")

}
\author{
James Bell
}
