% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GSRestRule.R
\docType{class}
\name{GSRestRule}
\alias{GSRestRule}
\title{A GeoServer access control list service rule}
\format{
\code{\link[R6]{R6Class}} object.
}
\value{
Object of \code{\link[R6]{R6Class}} for modelling a GeoServer access control list service rule
}
\description{
This class models a GeoServer access control list service rule
}
\details{
Geoserver REST API Access Control List REST Rule
}
\author{
Emmanuel Blondel <emmanuel.blondel1@gmail.com>
}
\keyword{access}
\keyword{api}
\keyword{control}
\keyword{geoserver}
\keyword{rest}
\keyword{rule}
\section{Super classes}{
\code{\link[geosapi:GSRESTResource]{geosapi::GSRESTResource}} -> \code{\link[geosapi:GSRule]{geosapi::GSRule}} -> \code{GSRestRule}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{roles}}{one or more roles}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-GSRestRule-new}{\code{GSRestRule$new()}}
\item \href{#method-GSRestRule-clone}{\code{GSRestRule$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="getClassName"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-getClassName'><code>geosapi::GSRESTResource$getClassName()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRESTResource" data-id="print"><a href='../../geosapi/html/GSRESTResource.html#method-GSRESTResource-print'><code>geosapi::GSRESTResource$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRule" data-id="decode"><a href='../../geosapi/html/GSRule.html#method-GSRule-decode'><code>geosapi::GSRule$decode()</code></a></span></li>
<li><span class="pkg-link" data-pkg="geosapi" data-topic="GSRule" data-id="encode"><a href='../../geosapi/html/GSRule.html#method-GSRule-encode'><code>geosapi::GSRule$encode()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSRestRule-new"></a>}}
\if{latex}{\out{\hypertarget{method-GSRestRule-new}{}}}
\subsection{Method \code{new()}}{
Initializes a \link{GSLayerRule}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSRestRule$new(
  xml = NULL,
  pattern,
  methods,
  permission = c("r", "w", "a"),
  roles
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{xml}}{an object of class \link[xml2]{xml_node-class}}

\item{\code{pattern}}{a URL Ant pattern, only applicable for domain \code{rest}. Default is \code{/**}}

\item{\code{methods}}{HTTP method(s)}

\item{\code{permission}}{the rule permission, either \code{r} (read), \code{w} (write) or \code{a} (administer)}

\item{\code{roles}}{one or more roles to add for the rule}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-GSRestRule-clone"></a>}}
\if{latex}{\out{\hypertarget{method-GSRestRule-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{GSRestRule$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
