% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_geo_codes.R
\name{add_geo_codes}
\alias{add_geo_codes}
\title{Agrega columnas con id geográficos asignados a poligonos de provincias o departamentos de Argentina
(\emph{Augment Argentina's districts polygons id})}
\usage{
add_geo_codes(data)
}
\arguments{
\item{data}{data.frame obtenido con \code{\link{get_geo}}. Los mapas disponibles
se pueden chequear con \code{\link{show_arg_codes}}.}
}
\value{
Los valores por defecto en \code{\link{get_geo}} son \code{codprov_censo} para provincia y \code{coddepto_censo} para departamentos, respectivamente.
Estos corresponden a la codificación de INDEC.
Con el agregado usando \code{add_geo_codes} se puede optar por las nomenclaturas de \code{'indra'} - correspondiente a los escrutinios provisorios de elecciones nacionales,
con las variantes \code{codprov} y \code{coddepto}, o la de \code{'iso'} con \code{\*_iso} , estas últimas hasta el nivel
provincial.
}
\description{
Función que permite agregar columnas con ids geográficos para utilización de mapas de Argentina y de departamentos para los 24 distritos
sub nacionales para una más sencilla la vinculación con bases de datos de diversas fuentes.
}
\details{
Respecto el origen de los datos se puede consultar la documentación de
\href{https://www.iso.org/obp/ui/#iso:code:3166:AR}{\code{ISO 3166-2} - International Organization for Standardization} y
del \href{https://www.iso.org/obp/ui/#iso:code:3166:AR}{\emph{INDEC}}.

\code{codprov} y \code{coddepto} son las codificaciones de las bases de datos de \emph{INDRA}, empresa encargada por
muchos años de la tarea del escrutinio provisorio y utilizados en \href{https://electorarg.github.io/polAr/}{polAr}.
}
\examples{

get_geo("TUCUMAN")


get_geo("TUCUMAN") \%>\%
   add_geo_codes()


}
