qSB <-
function(p, lambda=0, lower.tail = TRUE, log.p = FALSE)
{
if(lambda< -1 | lambda>1) stop("lambda must be between -1 and 1")
delta=(1-lambda)/2
Qy<-ifelse(rep(lambda,length(p))==0,log(p),log((-1+delta+sqrt(p*(2*delta-1)+(1-delta)^2))/(2*delta-1)))
Qy <- ifelse(p <= 0, -Inf, Qy)
Qy <- ifelse(p >= 1, Inf, Qy)
if(log.p == FALSE) Qy <- exp(Qy)
if(lower.tail==FALSE) Qy<-1-Qy
Qy
}
