% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{get.halftime}
\alias{get.halftime}
\title{Get half time by linear fitting}
\usage{
get.halftime(time, val)
}
\arguments{
\item{time}{vector of time}

\item{val}{vector of values}
}
\value{
half time
}
\description{
get half time according to http://www.amylofit.ch.cam.ac.uk
The algorithm for the extraction of the half times proceeds as follows: first the middle
part of the curve is selected, by determining when the average over several points is first
above 0.3 and when the average is last below 0.7. The number of points to be averaged
over depends on the number of points in the curve. A straight line is then fitted to this
middle part of the curve, the point at which it crosses the value of 0.5 is recorded as the
half time. (source: DOI: nprot.2016.010)
}
\examples{
get.halftime(c(1:10), c(0,1,2,3,4,5,6,7,8,9))
get.halftime(c(1:10), c(0,0,1,3,5,7,9,10,10,10))

}
