% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting_functions.R
\name{plot_raster_single}
\alias{plot_raster_single}
\title{Plot a single set of values onto a given landscape}
\usage{
plot_raster_single(values, landscape, title, no_data = 0, col, legend = TRUE)
}
\arguments{
\item{values}{a named list of values, the names must correspond to cells in the landscape}

\item{landscape}{a landscape to plot the values onto}

\item{title}{a title string for resulting plot, the time information will be taken and appended from the landscape id}

\item{no_data}{what value should be used for missing values in values}

\item{col}{corresponds to the col plot parameter. This can be omitted and colors are handled by raster::plot}

\item{legend}{corresponds to the legend plot parameter. This can be omitted and legend is handled by raster::plot}
}
\value{
no return value, called for plot
}
\description{
Plot a single set of values onto a given landscape
}
\examples{
# get path to output objects
datapath <- system.file(file.path("extdata", "WorldCenter"), package = "gen3sis")

# plot environmental variables at a given step
landscape_t_25 <- readRDS(
  file.path(datapath, "output", "config_worldcenter", "landscapes", "landscape_t_25.rds"))
oldpar <- par(no.readonly = TRUE)
par(mfrow=c(1,2))
plot_raster_single(landscape_t_25$environment[,"temp"], landscape_t_25, "Temperature", NA)
# use col to change the color
plot_raster_single(landscape_t_25$environment[,"arid"], landscape_t_25, "Aridity", NA, 
                   col=topo.colors(5))
par(oldpar)
# note that these values were scaled by the configuration object
}
