% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/knock.in.R
\name{knock.in}
\alias{knock.in}
\alias{knock.out}
\title{Knock-in and knock-out of effect(s)}
\usage{
knock.in(object, effect, residuals = TRUE)

knock.out(object, effect, residuals = TRUE)
}
\arguments{
\item{object}{GEM object.}

\item{effect}{Name or number of effect (character or numeric vector).}

\item{residuals}{Logical indicating if residuals should be added (default = TRUE).}
}
\value{
A \code{data.frame} of ER values where effects have been knocked in
(isolated/extracted from data) or knocked out (removed from data).
}
\description{
Convenience functions to apply to GEM objects to isolate/extract (knock-in) one or more effects
(and possibly residuals) or to remove (knock-out) one or more effects.
}
\examples{
data(MS, package = "gemR")

# Subset to reduce runtime in example
MS$proteins <- MS$proteins[,20:70]

gem <- GEM(proteins ~ MS * group, data = MS)

# Extract interaction between 'MS' and 'group
ER.isolated <- knock.in(gem, 'MS:group')

# Remove main effect of 'group'
ER.cleaned <- knock.out(gem, 'group')
}
