% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gelnet.R
\name{gelnet.ker}
\alias{gelnet.ker}
\title{Kernel models for linear regression, binary classification and one-class problems.}
\usage{
gelnet.ker(K, y, lambda, a, max.iter = 100, eps = 1e-05, v.init = rep(0,
  nrow(K)), b.init = 0, fix.bias = FALSE, silent = FALSE,
  balanced = FALSE)
}
\arguments{
\item{K}{n-by-n matrix of pairwise kernel values over a set of n samples}

\item{y}{n-by-1 vector of response values. Must be numeric vector for regression, factor with 2 levels for binary classification, or NULL for a one-class task.}

\item{lambda}{scalar, regularization parameter}

\item{a}{n-by-1 vector of sample weights (regression only)}

\item{max.iter}{maximum number of iterations (binary classification and one-class problems only)}

\item{eps}{convergence precision (binary classification and one-class problems only)}

\item{v.init}{initial parameter estimate for the kernel weights (binary classification and one-class problems only)}

\item{b.init}{initial parameter estimate for the bias term (binary classification only)}

\item{fix.bias}{set to TRUE to prevent the bias term from being updated (regression only) (default: FALSE)}

\item{silent}{set to TRUE to suppress run-time output to stdout (default: FALSE)}

\item{balanced}{boolean specifying whether the balanced model is being trained (binary classification only) (default: FALSE)}
}
\value{
A list with two elements:
\describe{
  \item{v}{n-by-1 vector of kernel weights}
  \item{b}{scalar, bias term for the linear model (omitted for one-class models)}
}
}
\description{
Infers the problem type and learns the appropriate kernel model.
}
\details{
The entries in the kernel matrix K can be interpreted as dot products
in some feature space \eqn{\phi}. The corresponding weight vector can be
retrieved via \eqn{w = \sum_i v_i \phi(x_i)}. However, new samples can be
classified without explicit access to the underlying feature space:
\deqn{w^T \phi(x) + b = \sum_i v_i \phi^T (x_i) \phi(x) + b = \sum_i v_i K( x_i, x ) + b}

The method determines the problem type from the labels argument y.
If y is a numeric vector, then a ridge regression model is trained by optimizing the following objective function:
\deqn{ \frac{1}{2n} \sum_i a_i (z_i - (w^T x_i + b))^2 + w^Tw }

If y is a factor with two levels, then the function returns a binary classification model, obtained by optimizing the following objective function:
\deqn{ -\frac{1}{n} \sum_i y_i s_i - \log( 1 + \exp(s_i) ) + w^Tw }
 where
\deqn{ s_i = w^T x_i + b }

Finally, if no labels are provided (y == NULL), then a one-class model is constructed using the following objective function:
\deqn{ -\frac{1}{n} \sum_i s_i - \log( 1 + \exp(s_i) ) + w^Tw }
 where
\deqn{ s_i = w^T x_i }

In all cases, \eqn{w = \sum_i v_i \phi(x_i)} and the method solves for \eqn{v_i}.
}
\seealso{
\code{\link{gelnet}}
}

