% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_rgee_ready}
\alias{check_rgee_ready}
\title{Check Google Earth Engine connection}
\usage{
check_rgee_ready(conda = NULL, verbose = interactive())
}
\arguments{
\item{conda}{[optional] (character) Name of a Conda environment to bind via
\code{reticulate::use_condaenv()} before checking credentials. If
\code{NULL} (default), the current reticulate binding is used.}

\item{verbose}{[optional] (logical) If \code{TRUE}, prints a short diagnostic
message when GEE is not ready. Defaults to \code{interactive()} so CRAN/CI
stays quiet.}
}
\value{
Logical, invisibly: \code{TRUE} if ready, \code{FALSE} otherwise.
}
\description{
Returns \code{TRUE} if the user is authenticated with Google Earth Engine
via \pkg{rgee}, without triggering any interactive prompts.
If \code{conda} is provided, the function first tries to bind that Conda
environment non-interactively (CRAN-safe), then checks credentials.
}
\keyword{internal}
