% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{eggnog_df}
\alias{eggnog_df}
\title{EggNOG Functional Annotation Results}
\format{
A data frame with multiple rows and 21 variables:
\describe{
\item{#query}{Character. Protein query identifier (e.g., "Houyiibacteriaceae--LLY-WYZ-15_3---k141_356661_13").}
\item{seed_ortholog}{Character. Subject protein identifier from EggNOG database (e.g., "1168065.DOK_14784").}
\item{evalue}{Numeric. Expect value for the annotation.}
\item{score}{Numeric. Annotation bitscore.}
\item{eggNOG_OGs}{Character.}
\item{max_annot_lvl}{Character.}
\item{COG_category}{Character.}
\item{Description}{Character. Functional description (e.g., "Bacterial regulatory proteins, tetR family").}
\item{Preferred_name}{Character. Gene name if available (e.g., "cobB").}
\item{GOs}{Character.}
\item{EC}{Character. Enzyme Commission number if applicable (e.g., "2.7.7.49").}
\item{KEGG_ko}{Character. KEGG Orthology identifier if available (e.g., "ko:K00986").}
\item{KEGG_Pathway}{Character.}
\item{KEGG_Module}{Character.}
\item{KEGG_Reaction}{Character.}
\item{KEGG_rclass}{Character.}
\item{BRITE}{Character.}
\item{KEGG_TC}{Character.}
\item{CAZy}{Character.}
\item{BiGG_Reaction}{Character.}
\item{PFAMs}{Character.}
}
}
\usage{
eggnog_df
}
\description{
A dataset containing EggNOG functional annotation results,
including taxonomic classification, functional categories, and domain information.
}
\keyword{datasets}
