% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\name{comperf}
\alias{comperf}
\title{Compute model performance}
\usage{
comperf(y, yhat, w = rep(1, length(y)), pfmc = NULL, cdfx = "fpr",
  cdfy = "tpr", dspt = 0.5)
}
\arguments{
\item{y}{a vector of numeric response values.}

\item{yhat}{a vector of model predictions.}

\item{w}{an optional vector of observation weights.}

\item{pfmc}{a character of the performance metric. For binary classification,
\code{pfmc} accepts:
\itemize{
\item \code{"acc"}: accuracy
\item \code{"dev"}: deviance
\item \code{"ks"}: Kolmogorov-Smirnov (KS) statistic
\item \code{"auc"}: area under the ROC curve. Use the \code{cdfx} and
\code{cdfy} arguments to specify the cumulative distributions for the x-axis
and y-axis of the ROC curve, respectively. The default ROC curve is given by
true positive rate (y-axis) vs. false positive rate (x-axis).
\item \code{"roc"}: rate on the y-axis of the ROC curve at a particular
decision point (threshold) on the x-axis specified by the \code{dspt}
argument. For example, if the desired performance metric is true positive
rate at the 5\% false positive rate, specify \code{pfmc="roc"},
\code{cdfx="fpr"}, \code{cdfy="tpr"}, and \code{dspt=0.05}.
}
For regression, \code{pfmc} accepts:
\itemize{
\item \code{"mse"}: mean squared error
\item \code{"mae"}: mean absolute error
\item \code{"rsq"}: r-squared (coefficient of determination)
}}

\item{cdfx}{a character of the cumulative distribution for the x-axis.
Supported values are
\itemize{
\item \code{"fpr"}: false positive rate
\item \code{"fnr"}: false negative rate
\item \code{"rpp"}: rate of positive prediction
}}

\item{cdfy}{a character of the cumulative distribution for the y-axis.
Supported values are
\itemize{
\item \code{"tpr"}: true positive rate
\item \code{"tnr"}: true negative rate
}}

\item{dspt}{a decision point (threshold) in [0, 1] for binary classification.
If \code{pfmc="acc"}, instances with probabilities <= \code{dspt} are
predicted as negative, and those with probabilities > \code{dspt} are
predicted as positive. If \code{pfmc="roc"}, \code{dspt} is a threhold on the
x-axis of the ROC curve such that the corresponding value on the y-axis is
used as the performance metric. For example, if the desired performance
metric is the true positive rate at the 5\% false positive rate, specify
\code{pfmc="roc"}, \code{cdfx="fpr"}, \code{cdfy="tpr"}, and \code{dspt=0.05}.}
}
\value{
A single or a vector of numeric values of model performance, or a
list of two components \code{x} and \code{y} representing the ROC curve.
}
\description{
This function computes model performance given a vector of response values
and a vector of predictions.
}
\examples{
y = c(0, 1, 0, 1, 1, 1)
yhat = c(0.5, 0.9, 0.2, 0.7, 0.6,  0.4)
comperf(y, yhat, pfmc = "auc")
# 0.875

y = 1:10
yhat = c(1:5 - 0.1, 6:10 + 0.1)
comperf(y, yhat, pfmc = "mse")
# 0.01

}
\author{
Waley W. J. Liang <\email{wliang10@gmail.com}>
}
\seealso{
\code{\link{gbts}},
         \code{\link{predict.gbts}}
}

