% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/proxy.R
\name{g6_update_nodes}
\alias{g6_update_nodes}
\alias{g6_update_edges}
\alias{g6_update_combos}
\title{Update nodes/edges/combos to a g6 graph via proxy}
\usage{
g6_update_nodes(graph, ...)

g6_update_edges(graph, ...)

g6_update_combos(graph, ...)
}
\arguments{
\item{graph}{A g6_proxy object created with \code{\link{g6_proxy}}.}

\item{...}{Nodes or edges or combos. You can pass a list of nodes/edges/combos, a dataframe
or leverage the g6_nodes(), g6_edges() or g6_combos() helpers or pass individual elements like
g6_node(), g6_edge() or g6_combo(). Elements structure must be compliant with specifications listed at
\url{https://g6.antv.antgroup.com/manual/element/overview}.}
}
\value{
The g6_proxy object (invisibly), allowing for method chaining.
}
\description{
This function updates one or more nodes/edges/combos to an existing g6 graph instance
using a proxy object. This allows updating the graph without completely
re-rendering it.
}
\details{
This function can only be used with a g6_proxy object within a Shiny application.
It will not work with regular g6 objects outside of Shiny.

See \url{https://g6.antv.antgroup.com/en/api/data#graphupdatenodedata},
\url{https://g6.antv.antgroup.com/en/api/data#graphupdateedgedata} and
\url{https://g6.antv.antgroup.com/en/api/data#graphupdatecombodata} for more details.
}
\examples{
if (interactive()) {
  library(shiny)
  library(g6R)
  library(bslib)

  # Static data defined globally
  nodes <- data.frame(id = 1:3)
  edges <- data.frame(source = c(1, 2), target = c(2, 3))

  ui <- page_fluid(
    title = "Update Nodes Dynamically",
    g6_output("graph"),
    actionButton("update_node", "Update Node 1 Label")
  )

  server <- function(input, output, session) {
    output$graph <- render_g6({
      g6(nodes = nodes, edges = edges) |> g6_layout()
    })

    observeEvent(input$update_node, {
      # Update label for node 1
      g6_update_nodes(
        g6_proxy("graph"),
        g6_node(id = 1, style = list(labelText = "Node label updated"))
      )
    })
  }

  shinyApp(ui, server)
}

}
\seealso{
\code{\link{g6_proxy}}, \code{\link{g6_remove_nodes}}
}
