% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KNN_DNA.R
\name{KNN_DNA}
\alias{KNN_DNA}
\title{K-Nearest Neighbor_DNA (KNN_DNA)}
\usage{
KNN_DNA(seqs, trainSeq, percent = 30, labeltr = c(), label = c())
}
\arguments{
\item{seqs}{is a FASTA file containing nucleotide sequences. The sequences start
with '>'. Also, seqs could be a string vector. Each element of the vector is a nucleotide sequence.}

\item{trainSeq}{is a fasta file with nucleotide sequences. Each sequence starts
with a '>' character. Also it could be a string vector such that each element is a nucleotide sequence. Eaxh sequence in the training set
is associated with a label. The label is found in the parameret labeltr.}

\item{percent}{determines the threshold which is used to identify sequences (in the training set) which are similar to the input sequence.}

\item{labeltr}{This parameter is a vector whose length is equivalent to the number of sequences in the training set. It shows class of
each sequence in the trainig set.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix such that number of columns is number of classes multiplied by percent and number of rows is equal to the number of the sequences.
}
\description{
This function is like \link{KNNPeptide} with the difference that similarity score is computed by Needleman-Wunsch algorithm.
}
\examples{

ptmSeqsADR<-system.file("extdata/",package="ftrCOOL")
seqs<-fa.read(file=paste0(ptmSeqsADR,"/testData51.txt"),alphabet="dna")

posSeqs<-fa.read(file=paste0(ptmSeqsADR,"/posData51.txt"),alphabet="dna")
negSeqs<-fa.read(file=paste0(ptmSeqsADR,"/negData51.txt"),alphabet="dna")


trainSeq<-c(posSeqs,negSeqs)

labelPos<-rep(1,length(posSeqs))
labelNeg<-rep(0,length(negSeqs))

labeltr<-c(labelPos,labelNeg)

KNN_DNA(seqs=seqs,trainSeq=trainSeq,percent=5,labeltr=labeltr)

}
\references{
Chen, Zhen, et al. "iFeature: a python package and web server for features extraction and selection from protein and peptide sequences." Bioinformatics 34.14 (2018): 2499-2502.
}
