% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frameSphere.R
\name{frameSphere}
\alias{frameSphere}
\title{Generate a "natural" frame (orthonormal basis)}
\usage{
frameSphere(x)
}
\arguments{
\item{x}{A unit vector of length \eqn{d}.}
}
\value{
A \eqn{d}-by-\eqn{(d-1)} matrix where columns hold the orthonormal basis of the tangent space at \code{x} on the unit sphere.
}
\description{
Generate a "natural" frame (orthonormal basis) for the tangent space at \code{x} on the unit sphere.
}
\details{
The first \eqn{(i+1)} elements of the \eqn{i}th basis vector are given by 
\eqn{\sin\theta_i\prod_{j=1}^{i-1}\cos\theta_j}, \eqn{\sin\theta_i\sin\theta_1 \prod_{j=2}^{i-1}\cos\theta_j},
\eqn{\sin\theta_i\sin\theta_2 \prod_{j=3}^{i-1}\cos\theta_j}, \eqn{\dots}, \eqn{\sin\theta_i\sin\theta_{i-1}}, \eqn{-\cos\theta_i}, respectively.
The rest elements (if any) of the \eqn{i}th basis vector are all zero.
}
\examples{
frameSphere(c(1,0,0,0))
}
