% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_string.R
\name{format_string}
\alias{format_string}
\title{Format a Character Vector}
\usage{
format_string(
  x,
  style = c("title", "sentence"),
  str2ws = "_",
  str4split = " |-",
  strict = TRUE,
  arguments = list(),
  protect_curly_braces = FALSE,
  lowercase_words = NULL,
  protected_words = NULL,
  punctuation = NULL,
  ...
)
}
\arguments{
\item{x}{A character vector that needs formatting.}

\item{style}{A character string for specifying case style. \code{"title"}
for title case or \code{"sentence"} for sentence case.}

\item{str2ws}{Character expression that would be replaced with white space.
By default, underscores will be replaced with white spaces.}

\item{str4split}{Character expression that would be used to split the string
into individual words.}

\item{strict}{A logical value specifying whether to lower the cases for
letters after the first letter.  The default value is \code{TRUE}.}

\item{arguments}{An optional argument list for specifying more details when
replacing specified characters with whitespaces by using
\code{\link[base]{gsub}}.}

\item{protect_curly_braces}{A logical vector of length one indicating if
curly braces represent a block that needs protection.  This argument is
mainly intended to format BibTeX entries.}

\item{lowercase_words}{Some words that should be almost always be lowercase.
The default values are \code{format_options$get("lowercase_words")}.}

\item{protected_words}{Some words that should be kept in original case and
should be not be convert to lowercase or uppercase.  The default values
are \code{format_options$get("protected_words")}.}

\item{punctuation}{A character expression that should be considered as
punctuation and should not be considered as a part of the protected
words.  The function would remove these punctuation before checking
whether the words need protecting.  The default values are
\code{format_options$get("punctuation")}.}

\item{...}{Other arguments that are not used now.}
}
\value{
A character vector of the same length as the input.
}
\description{
This function formats a character vector by following APA (American
Psychological Assoication) style.
}
\details{
The available style options are title case and sentence case.  The first
word of the string and the first word after colon will be always
capitalized.  For title case (default), the function would capitalize each
word with a few exceptions, such as short conjunctions and prepositions.
For sentence case, the function would not capitalize a word unless it
starts a string, come after a colon, or is a proper noun.  We may specify
some words that need protection from any kind of case conversion.

The function would also replace possible splitting characters, such as
underscores with white spaces.  Empty strings (\code{""} or \code{''}),
\code{NA}, \code{character(0)}, and \code{NULL} are allowed and returned as
they were.
}
\examples{
library(formatBibtex)

## simple examples
foo <- c("iT IS_A_sIMPLe_ExamplE.", "let'S_do soMe_tesTs!")
format_string(foo, style = "title")
format_string(foo, style = "sentence")

## default words that would be protected from formatting
format_options$get("protected_words")

## e.g., protect ABCD and MCMC from being converted to lowercase
format_options$append("protected_words", c("ABCD", "MCMC"))

bar <- c("on_the_convergence properties of the ABCD_algorithm",
         "teSt: tHe cluster is Running MCMC!")
format_string(bar, style = "sentence")

## more tricky examples: protected words contain `str4split`
foo <- c("nineteenth- and twentieth-century writers",
         "well-differentiated cells with arXiv e-prints")
format_string(foo, str4split = "-| ",
              protected_words = c("arXiv", "e-prints"))

## trivial examples
format_string(NULL)
format_string(character(0))
format_string(character(3))
format_string(c(NA, "", "hello world!"))
}
