% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemical.R
\docType{data}
\name{kommos}
\alias{kommos}
\title{Transport Jars from Kommos (Crete)}
\format{
A \code{data.frame} with 88 observations and 22 variables (chemical elements):
\describe{
\item{type}{\code{\link{factor}}: \code{CJ} (Canaanite jar), \code{EJ} (Egyptian jar);
\code{TSJ} (transport stirrup jar), \code{SNA} (short-necked amphora).}
\item{date}{\code{\link{character}}: chronology (period).}
\item{Sm}{\code{\link{numeric}}: Sm content (ppm).}
\item{Lu}{\code{\link{numeric}}: Lu content (ppm).}
\item{U}{\code{\link{numeric}}: U content (ppm).}
\item{Yb}{\code{\link{numeric}}: Yb content (ppm).}
\item{As}{\code{\link{numeric}}: As content (ppm).}
\item{Sb}{\code{\link{numeric}}: Sb content (ppm).}
\item{Ca}{\code{\link{numeric}}: Ca content (ppm).}
\item{Na}{\code{\link{numeric}}: Na content (ppm).}
\item{La}{\code{\link{numeric}}: La content (ppm).}
\item{Ce}{\code{\link{numeric}}: Ce content (ppm).}
\item{Th}{\code{\link{numeric}}: Th content (ppm).}
\item{Cr}{\code{\link{numeric}}: Cr content (ppm).}
\item{Hf}{\code{\link{numeric}}: Hf content (ppm).}
\item{Cs}{\code{\link{numeric}}: Cs content (ppm).}
\item{Sc}{\code{\link{numeric}}: Sc content (ppm).}
\item{Rb}{\code{\link{numeric}}: Rb content (ppm).}
\item{Fe}{\code{\link{numeric}}: Fe content (ppm).}
\item{Ta}{\code{\link{numeric}}: Ta content (ppm).}
\item{Co}{\code{\link{numeric}}: Co content (ppm).}
\item{Eu}{\code{\link{numeric}}: Eu content (ppm).}
}
}
\usage{
kommos
}
\description{
Chemical analysis (neutron activation analysis) of 88 Late Bronze Age
transport jars found in excavations at Kommos, Crete.
}
\references{
Day, P. M., Quinn, P. S., Rutter, J. B. & Kilikoglou, V. (2011).
A World of Goods: Transport Jars and Commodity Exchange at the Late Bronze
Age Harbor of Kommos, Crete. \emph{Hesperia}, 80, 511-558.
\doi{10.2972/hesperia.80.4.0511}
}
\seealso{
Other chemical data: 
\code{\link{bronze}},
\code{\link{verre}}
}
\concept{chemical data}
\keyword{datasets}
