% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/12_flow_view_source_calls.R
\name{flow_view_source_calls}
\alias{flow_view_source_calls}
\title{Draw diagram of source dependencies}
\usage{
flow_view_source_calls(
  paths = ".",
  recursive = TRUE,
  basename = TRUE,
  extension = FALSE,
  smart = TRUE,
  out = NULL
)
}
\arguments{
\item{paths}{Paths to scripts or folders containing scripts
By default explores the working directory.}

\item{recursive}{Passed to \code{list.files()} when \code{paths} contains directories}

\item{basename}{Whether to display only the base name of the script}

\item{extension}{Whether to display the extension}

\item{smart}{Whether to parse complex source calls for strings that look like script and
match those to files found in \code{paths}}

\item{out}{a path to save the diagram to.
Special values "html", "htm", "png", "pdf", "jpg" and "jpeg" can be used to
export the object to a temp file of the relevant format and open it,
if a regular path is used the format will be guessed from the extension.}
}
\value{
\code{flow_view_source_calls()} returns a \code{"flow_diagram"} object by default, and the output path invisibly if \code{out} is not
\code{NULL} (called for side effects). \code{flow_run()} returns the output of the wrapped call.
}
\description{
Assuming a project where files source each other, draw their dependency graph.
}
\details{
This evaluates the \code{file} argument of \code{source} in the global environment,
when this fails, as it might with constructs like \code{for (file in files) source(file)}
the unevaluated argument is printed instead between backticks. Since this messes
up the relationships in the graph, an warning is thus issued. In a case like \verb{source(file.path(my_dir, "foo.R")}
defining \code{my_dir} will be enough to solve the issue.
In the latter case, if \code{smart} is \code{TRUE}, the function will check in all the paths in scope
if any script is named "foo.R" and will consider it if a single fitting candidate is found.
}
