% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_precursor.R
\name{convert_precursor}
\alias{convert_precursor}
\title{Conversion of software specific precursor entries}
\usage{
convert_precursor(
  input_df,
  software = c("MaxQuant", "PD", "DIA-NN", "Spectronaut")
)
}
\arguments{
\item{input_df}{A tibble with precursor level information. For MaxQuant: evidence.txt, for PD: PSMs.txt with R-friendly headers enabled, for DIA-NN and Spectronaut default output reports.}

\item{software}{The used analysis software for the input_df - MaxQuant, PD, DIA-NN or Spectronaut. Default is MaxQuant.}
}
\value{
This function returns the original submitted \code{tibble} - input_df - including two new columns:
\itemize{
\item traceR_precursor - software-independent standardized text for precursor entries.
\item traceR_precursor_unknownMods - logical value, if TRUE: a modification is detected, which is not converted to a standardized text.
}
}
\description{
Precursor entries are converted to a common text representation
}
\details{
The input entries are converted to a software independent format. The generated entries are appended to the submitted dataframe. Conversion of modifications is currently only available for UniMod:35 and UniMod:4. Other modifications will not be converted to standardized format.
}
\examples{
# Load libraries
library(dplyr)
library(stringr)
library(tidyr)
library(tibble)

# MaxQuant example data
data <- tibble::tibble(
 "Modified sequence" = c("_AACLLPK_",
 "_ALTDM(Oxidation (M))PQM(Oxidation (M))R_",
 "ALTDM(Dummy_Modification)PQMK"),
  Charge = c(2,2,3)
)

# Conversion
convert_precursor(
 input_df = data,
 software = "MaxQuant"
)
}
\author{
Oliver Kardell
}
