% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gfw.summarize.R
\name{gfw.summarize}
\alias{gfw.summarize}
\title{Summarize GFW data on fishing effort}
\usage{
gfw.summarize(df)
}
\arguments{
\item{df}{A dataframe object as downloaded from GFW's Google Big Data Query.}
}
\value{
A dataframe.
}
\description{
Wrapper function for `dplyr::summarise()` that summarizes GFW data into the most important measures of central tendency for fishing_hours and hours, creating a new dataframe. It will have one (or more) rows for each combination of grouping variables; if there are no grouping variables, the output will have a single row summarising all observations in the input.
}
\examples{

dated <- c("2020-01-01", "2020-01-02")
lat <- c(40, 41)
lon <- c(12,13)
mmsi <- c("34534555", "25634555")
hours <- c(0, 5)
fishing_hours <- c(1,9)

df <- data.frame(dated, lat, lon, mmsi, hours, fishing_hours)

summary <- gfw.summarize(df)

print(summary)

}
\seealso{
[dplyr::summarise()] [dplyr::group_by()]
}
