% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SecurityHeaders.R
\name{SecurityHeaders}
\alias{SecurityHeaders}
\title{Plugin for setting security related headers}
\description{
This plugin is inspired by \href{https://helmetjs.github.io/}{Helmet.js} and aids
you in setting response headers relevant for security of your fiery server.
All defaults are taken from Helmet.js as well, except for the \code{max-age} of the
\code{Strict-Transport-Security} header that has been doubled to 2 years which is
the recommendation.
}
\details{
Web security is a complicated subject and it is impossible for this document
to stay current and true at all times as well as be able to learn the user of
all the intricacies of web security. It is \strong{strongly} advised that you
familiarise yourself with this subject if you plan on exposing a fiery
webserver to the public. A good starting point is
\href{https://developer.mozilla.org/docs/Web/Security}{MDN's guide on web security}.

This plugin concerns 14 different headers that are in one way or another
implicated in security. Some of them are only relevant if you serve HTML
content on the web and have no effect on e.g. a server providing a REST api.
These have been marked with \strong{UI} below. While you may turn these off for a
pure API server (by setting them to \code{NULL}), it is advised that you only
steer away from the defaults if you have a good grasp of the implications.
The headers are set very efficiently so removing some unneeded ones will only
have an effect on the size of the response, not the handling time.
\subsection{Headers}{
\subsection{\code{Content-Security-Policy} (\strong{UI})}{

This header provides finely grained control over what code can be executed on
the site you provide and thus help in preventing cross-site scripting (XSS)
attacks. The configuration of this header is complicated and you can read
more about it at \href{https://developer.mozilla.org/docs/Web/HTTP/Reference/Headers/Content-Security-Policy}{the header reference}
and \href{https://developer.mozilla.org/docs/Web/Security/Practical_implementation_guides/CSP}{the CSP section of the security guide}

The plugin does some light validation of the data structure you provide and
you can use the \code{\link[=csp]{csp()}} constructure to get argument tab-completion.
}

\subsection{\code{Content-Security-Policy-Report-Only} (\strong{UI})}{

This header is like \code{Content-Security-Policy} above except that it doesn't
enforce the policy but rather report any violations to a URL of your choice.
The reason for providing this is that setting up CSP correctly can be
difficult and may lead to your site not working correctly. Therefore, if you
apply CSP to an already excisting site it is often a good idea to start with
using this header and monitor where issues may arise before turning on the
policy fully. You provide the URL to send violation reports to with the
\code{report_to} directive which should be set to a URL. You can find more
information on this header at
\href{https://developer.mozilla.org/docs/Web/HTTP/Reference/Headers/Content-Security-Policy-Report-Only}{the header reference}
}

\subsection{\code{Cross-Origin-Embedder-Policy} (\strong{UI})}{

This header controls which resources can be embedded in a document. If set
to e.g. \code{require-corp} then only resources that implements CORP or CORS can
be embedded. It is not set by default in SecurityHeaders. Read more about this
header at \href{https://developer.mozilla.org/docs/Web/HTTP/Reference/Headers/Cross-Origin-Embedder-Policy}{MDN}
}

\subsection{\code{Cross-Origin-Opener-Policy} (\strong{UI})}{

This header controls and restricts access from cross-origin windows opened
from the site. It helps isolate new documents and prevent a type of attack known
as XS-Leaks. Read more about this header at \href{https://developer.mozilla.org/docs/Web/HTTP/Reference/Headers/Cross-Origin-Embedder-Policy}{MDN}
and about XS-Leaks \href{https://developer.mozilla.org/docs/Web/Security/Attacks/XS-Leaks}{in the security guide}
}

\subsection{\code{Cross-Origin-Resource-Policy}}{

This header controls where the given response can be used. If you e.g. return
an image along with \code{Cross-Origin-Resource-Policy: same-site}, then this
image is blocked from being loaded by other sites.
Read more about this header at \href{https://developer.mozilla.org/docs/Web/HTTP/Reference/Headers/Cross-Origin-Resource-Policy}{MDN}
and about CORP in general \href{https://developer.mozilla.org/docs/Web/Security/Practical_implementation_guides/CORP}{in the security guide}
}

\subsection{\code{Origin-Agent-Cluster} (\strong{UI})}{

This header helps isolate documents served from the same site into separate
processes. This can improve performance of other tabs if a resource
intensive tab is opened but also prevent certain information from being
available to code running in the tab. Read more about this header at
\href{https://developer.mozilla.org/docs/Web/HTTP/Reference/Headers/Origin-Agent-Cluster}{MDN}
}

\subsection{\code{Referrer-Policy} (\strong{UI})}{

This header instructs what to include in the \code{Referer} header when navigating
away from the document. This can potentially lead to information leakage
which can be alleviated using this header. Read more about this header at
\href{https://developer.mozilla.org/docs/Web/HTTP/Reference/Headers/Referrer-Policy}{MDN}
as well as the \href{https://developer.mozilla.org/docs/Web/Security/Referer_header:_privacy_and_security_concerns}{security implications of the \code{Referer} header}
}

\subsection{\code{Strict-Transport-Security}}{

This header informs a browser that the given resource should only be
accessed using HTTPS. This preference is cached by the browser and the next
time the resource is accessed over HTTP it is automatically changed to HTTPS
before the request is made. This header should only be sent over HTTPS to
prevent a manipulator-in-the-middle from alterning its settings. In order for
this to happen SecurityHeaders will automatically redirect any HTTP requests to
HTTPS if this header is set. Read more about this header at
\href{https://developer.mozilla.org/docs/Web/HTTP/Reference/Headers/Strict-Transport-Security}{MDN}
}

\subsection{\code{X-Content-Type-Options}}{

This header instruct the client that the MIME type provided by the
\code{Content-Type} should be respected and mime-type sniffing avoided. Setting
this can help prevent certain XSS attacks. Read more about this header at
\href{https://developer.mozilla.org/docs/Web/HTTP/Reference/Headers/X-Content-Type-Options}{MDN}
and about its security implication in the
\href{https://developer.mozilla.org/docs/Web/Security/Practical_implementation_guides/MIME_types}{security guide}
}

\subsection{\code{X-DNS-Prefetch-Control} (\strong{UI})}{

This header controls DNS prefetching and domain name resolution. A browser
may do this in the background when a site is loaded which can reduce latency
when a user clicks a link. However, it may also leak sensitive information so
turning it off may increase user privacy. Read more about this header at
\href{https://developer.mozilla.org/docs/Web/HTTP/Reference/Headers/X-DNS-Prefetch-Control}{MDN}
}

\subsection{\code{X-Download-Options} (\strong{UI})}{

This is an old header only relevant to Internet Explorer 8 and below that
prevents downloaded content from having access to your site's context.
}

\subsection{\code{X-Frame-Options} (\strong{UI})}{

This header has been superseeded by the \code{frame-ancestor} directive in the
\code{Content-Security-Policy} header but may still be good to set for older
browsers. It controls whether a site is allowed to be rendered inside a frame
in another document. Preventing this can prevent click-jacking attacks. Read
more about this header at \href{https://developer.mozilla.org/docs/Web/HTTP/Reference/Headers/X-Frame-Options}{MDN}
}

\subsection{\code{X-Permitted-Cross-Domain-Policies}}{

This header controls cross-origin access of a resource from a document
running in a web client such as Adobe Flash Player or Microsoft Silverlight.
The demise of these technologies have made this header less important. Read
more about this header at \href{https://developer.mozilla.org/docs/Web/HTTP/Reference/Headers/X-Permitted-Cross-Domain-Policies}{MDN}
}

\subsection{\code{X-XSS-Protection} (\strong{UI})}{

This header has been deprecated in favor of the more powerful
\code{Content-Security-Policy} header. In fact using XSS filtering can incur a
security vulnerability which is why the default for SecurityHeaders is to turn the
feature off (by setting \code{X-XSS-Protection: 0} rather than omitting the
header). Read more about this header at
\href{https://developer.mozilla.org/docs/Web/HTTP/Reference/Headers/X-XSS-Protection}{MDN}
}

}
}
\section{Initialization}{

A new 'SecurityHeaders'-object is initialized using the \code{new()} method on the
generator and pass in any settings deviating from the defaults

\strong{Usage}
\tabular{l}{
\code{security_headers <- SecurityHeaders$new(...)}
}
}

\section{Fiery plugin}{

A SecurityHeaders object is a fiery plugin and can be used by passing it to the
\code{attach()} method of the fiery server object. Once attached all requests
created will be prepopulated with the given headers. Any request handler is
permitted to remove one or more of the headers to opt out of them.
}

\examples{
# Create a plugin that turns off UI-related security headers
security_headers <- SecurityHeaders$new(
  content_security_policy = NULL,
  cross_origin_embedder_policy = NULL,
  cross_origin_opener_policy = NULL,
  origin_agent_cluster = NULL,
  referrer_policy = NULL,
  x_dns_prefetch_control = NULL,
  x_download_options = NULL,
  x_frame_options = NULL,
  x_xss_protection = NULL
)

\dontshow{if (requireNamespace("fiery", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Use it with a fiery server
app <- fiery::Fire$new()

app$attach(security_headers)
\dontshow{\}) # examplesIf}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{content_security_policy}}{Set or get the value of the
\code{Content-Security-Policy} header. See \code{\link[=csp]{csp()}} for documentation of its
values}

\item{\code{content_security_policy_report_only}}{Set or get the value of the
\code{Content-Security-Policy-Report-Only} header. See \code{\link[=csp]{csp()}} for
documentation of its values}

\item{\code{cross_origin_embedder_policy}}{Set or get the value of the
\code{Cross-Origin-Embedder-Policy}. Possible values are \code{"unsafe-none"},
\code{"require-corp"}, and \code{"credentialless"}}

\item{\code{cross_origin_opener_policy}}{Set or get the value of the
\code{Cross-Origin-Opener-Policy}. Possible values are \code{"unsafe-none"},
\code{"same-origin-allow-popups"}, \code{"same-origin"}, and
\code{"noopener-allow-popups"}}

\item{\code{cross_origin_resource_policy}}{Set or get the value of the
\code{Cross-Origin-Resource-Policy}. Possible values are \code{"same-site"},
\code{"same-origin"}, and \code{"cross-origin"}}

\item{\code{origin_agent_cluster}}{Set or get the value of the
\code{Origin-Agent-Cluster}. Possible values are \code{TRUE} and \code{FALSE}}

\item{\code{referrer_policy}}{Set or get the value of the
\code{Referrer-Policy}. Possible values are \code{"no-referrer"},
\code{"no-referrer-when-downgrade"}, \code{"origin"}, \code{"origin-when-cross-origin"},
\code{"same-origin"}, \code{"strict-origin"}, \code{"strict-origin-when-cross-origin"},
and \code{"unsafe-url"}}

\item{\code{strict_transport_security}}{Set or get the value of the
\code{Strict-Transport-Security} header. See \code{\link[=sts]{sts()}} for documentation of its
values}

\item{\code{x_content_type_options}}{Set or get the value of the
\code{X-Content-Type-Options}. Possible values are \code{TRUE} and \code{FALSE}}

\item{\code{x_dns_prefetch_control}}{Set or get the value of the
\code{X-DNS-Prefetch-Control}. Possible values are \code{TRUE} and \code{FALSE}}

\item{\code{x_download_options}}{Set or get the value of the
\code{X-Download-Options}. Possible values are \code{TRUE} and \code{FALSE}}

\item{\code{x_frame_options}}{Set or get the value of the
\code{X-Frame-Options}. Possible values are \code{"DENY"} and \code{"SAMEORIGIN"}}

\item{\code{x_permitted_cross_domain_policies}}{Set or get the value of the
\code{X-Permitted-Cross-Domain-Policies}. Possible values are \code{"none"},
\code{"master-only"}, \code{"by-content-type"}, \code{"by-ftp-filename"}, \code{"all"}, and
\code{"none-this-response"}}

\item{\code{x_xss_protection}}{Set or get the value of the
\code{X-XSS-Protection}. Possible values are \code{TRUE} and \code{FALSE}}

\item{\code{name}}{The name of the plugin}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-SecurityHeaders-new}{\code{SecurityHeaders$new()}}
\item \href{#method-SecurityHeaders-on_attach}{\code{SecurityHeaders$on_attach()}}
\item \href{#method-SecurityHeaders-clone}{\code{SecurityHeaders$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SecurityHeaders-new"></a>}}
\if{latex}{\out{\hypertarget{method-SecurityHeaders-new}{}}}
\subsection{Method \code{new()}}{
Initialize a new SecurityHeaders object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SecurityHeaders$new(
  content_security_policy = csp(default_src = "self", script_src = "self",
    script_src_attr = "none", style_src = c("self", "https:", "unsafe-inline"), img_src =
    c("self", "data:"), font_src = c("self", "https:", "data:"), object_src = "none",
    base_uri = "self", form_action = "self", frame_ancestors = "self",
    upgrade_insecure_requests = TRUE),
  content_security_policy_report_only = NULL,
  cross_origin_embedder_policy = NULL,
  cross_origin_opener_policy = "same-origin",
  cross_origin_resource_policy = "same-origin",
  origin_agent_cluster = TRUE,
  referrer_policy = "no-referrer",
  strict_transport_security = sts(max_age = 63072000, include_sub_domains = TRUE),
  x_content_type_options = TRUE,
  x_dns_prefetch_control = FALSE,
  x_download_options = TRUE,
  x_frame_options = "SAMEORIGIN",
  x_permitted_cross_domain_policies = "none",
  x_xss_protection = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{content_security_policy}}{Set the value of the \code{Content-Security-Policy}
header. See \code{\link[=csp]{csp()}} for documentation of its values}

\item{\code{content_security_policy_report_only}}{Set the value of the
\code{Content-Security-Policy-Report-Only} header. See \code{\link[=csp]{csp()}} for
documentation of its values}

\item{\code{cross_origin_embedder_policy}}{Set the value of the
\code{Cross-Origin-Embedder-Policy}. Possible values are \code{"unsafe-none"},
\code{"require-corp"}, and \code{"credentialless"}}

\item{\code{cross_origin_opener_policy}}{Set the value of the
\code{Cross-Origin-Opener-Policy}. Possible values are \code{"unsafe-none"},
\code{"same-origin-allow-popups"}, \code{"same-origin"}, and
\code{"noopener-allow-popups"}}

\item{\code{cross_origin_resource_policy}}{Set the value of the
\code{Cross-Origin-Resource-Policy}. Possible values are \code{"same-site"},
\code{"same-origin"}, and \code{"cross-origin"}}

\item{\code{origin_agent_cluster}}{Set the value of the
\code{Origin-Agent-Cluster}. Possible values are \code{TRUE} and \code{FALSE}}

\item{\code{referrer_policy}}{Set the value of the
\code{Referrer-Policy}. Possible values are \code{"no-referrer"},
\code{"no-referrer-when-downgrade"}, \code{"origin"}, \code{"origin-when-cross-origin"},
\code{"same-origin"}, \code{"strict-origin"}, \code{"strict-origin-when-cross-origin"},
and \code{"unsafe-url"}}

\item{\code{strict_transport_security}}{Set the value of the
\code{Strict-Transport-Security} header. See \code{\link[=sts]{sts()}} for documentation of its
values}

\item{\code{x_content_type_options}}{Set the value of the
\code{X-Content-Type-Options}. Possible values are \code{TRUE} and \code{FALSE}}

\item{\code{x_dns_prefetch_control}}{Set the value of the
\code{X-DNS-Prefetch-Control}. Possible values are \code{TRUE} and \code{FALSE}}

\item{\code{x_download_options}}{Set the value of the
\code{X-Download-Options}. Possible values are \code{TRUE} and \code{FALSE}}

\item{\code{x_frame_options}}{Set the value of the
\code{X-Frame-Options}. Possible values are \code{"DENY"} and \code{"SAMEORIGIN"}}

\item{\code{x_permitted_cross_domain_policies}}{Set the value of the
\code{X-Permitted-Cross-Domain-Policies}. Possible values are \code{"none"},
\code{"master-only"}, \code{"by-content-type"}, \code{"by-ftp-filename"}, \code{"all"}, and
\code{"none-this-response"}}

\item{\code{x_xss_protection}}{Set the value of the
\code{X-XSS-Protection}. Possible values are \code{TRUE} and \code{FALSE}}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SecurityHeaders-on_attach"></a>}}
\if{latex}{\out{\hypertarget{method-SecurityHeaders-on_attach}{}}}
\subsection{Method \code{on_attach()}}{
Method for use by \code{fiery} when attached as a plugin. Should
not be called directly.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SecurityHeaders$on_attach(app, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{app}}{The fiery server object}

\item{\code{...}}{Ignored}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-SecurityHeaders-clone"></a>}}
\if{latex}{\out{\hypertarget{method-SecurityHeaders-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{SecurityHeaders$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
