% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_comparison_functions.R
\name{fst_get_unique_ngrams}
\alias{fst_get_unique_ngrams}
\title{Get unique n-grams from a list of top n-grams tables}
\usage{
fst_get_unique_ngrams(list_of_top_ngrams)
}
\arguments{
\item{list_of_top_ngrams}{A list of top ngrams}
}
\value{
Dataframe of words and whether word is unique or not.
}
\description{
Takes a list containing at least two tables of n-grams and frequencies
(either output of `fst_freq_table()` or `fst_ngrams_table()`) and finds
n-grams unique to one table.
}
\examples{
top_child <- fst_freq_table(fst_child)
top_dev <- fst_freq_table(fst_dev_coop)
list_of_top_words <- list()
list_of_top_words <- append(list_of_top_words, list(top_child))
list_of_top_words <- append(list_of_top_words, list(top_dev))
fst_get_unique_ngrams(list_of_top_words)
}
