% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{scatterplot}
\alias{scatterplot}
\title{Clustering Scatter Plots}
\usage{
scatterplot(
  d,
  clusters,
  centers = NULL,
  labels = FALSE,
  ellipses = FALSE,
  legend = c("auto1", "auto2"),
  ...
)
}
\arguments{
\item{d}{The dataset (\code{matrix} or \code{data.frame}).}

\item{clusters}{Cluster labels of the training set (\code{vector} or \code{factor}).}

\item{centers}{Coordinates of the cluster centers.}

\item{labels}{Indicates whether or not labels (row names) should be showned on the plot.}

\item{ellipses}{Indicates whether or not ellipses should be drawned around clusters.}

\item{legend}{Indicates where the legend is placed on the graphics.}

\item{...}{Other parameters.}
}
\description{
Produce a scatter plot for clustering results. If the dataset has more than two dimensions, the scatter plot will show the two first PCA axes.
}
\examples{
require (datasets)
data (iris)
km = KMEANS (iris [, -5], k = 3)
scatterplot (iris [, -5], km$cluster)
}
