% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_fct.R
\name{ft_na}
\alias{ft_na}
\title{Handle NA Values in Factor Vectors}
\usage{
ft_na(factor_vec, keep_na = TRUE)
}
\arguments{
\item{factor_vec}{A factor vector to be processed.}

\item{keep_na}{Logical. Should NA values be kept as a level in the factor? Default is \code{TRUE}.}
}
\value{
A factor vector with NA values handled as specified.
}
\description{
Handles NA values in a factor vector by either keeping NA as a level or removing levels and characters corresponding to NA values.
}
\examples{
# Example factor vector with NA values
factor_vec <- factor(c('apple', NA, 'banana', 'cherry', NA, 'date'))

# Keep NA as a level
ft_na(factor_vec, keep_na = TRUE)

# Remove NA values
ft_na(factor_vec, keep_na = FALSE)
}
\author{
Kai Guo
}
