% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fillHoles.r
\name{fillHoles,GVector-method}
\alias{fillHoles,GVector-method}
\alias{fillHoles}
\title{Fill holes in a GVector}
\usage{
\S4method{fillHoles}{GVector}(x, fail = TRUE)
}
\arguments{
\item{x}{A \code{GVector}.}

\item{fail}{Logical: If \code{TRUE} (default), and \strong{GRASS 8.3} or higher is not installed, cause an error. If \code{FALSE}, a warning will be displayed and a \code{NULL} value will be returned. This function requires \strong{GRASS 8.3} or higher to be installed.}
}
\value{
A \code{GVector}.
}
\description{
\code{fillHoles()} removes holes in a \code{GVector}.
}
\examples{
if (grassStarted()) {

# Setup
library(sf)

# Example data:
madCoast4 <- fastData("madCoast4")
madRivers <- fastData("madRivers")
madDypsis <- fastData("madDypsis")

# Convert sf vectors to GVectors:
coast <- fast(madCoast4)
rivers <- fast(madRivers)
dypsis <- fast(madDypsis)

# Geographic properties:
ext(rivers) # extent
crs(rivers) # coordinate reference system
st_crs(rivers) # coordinate reference system
coordRef(rivers) # coordinate reference system

# Column names and data types:
names(coast)
datatype(coast)

# Points, lines, or polygons?
geomtype(dypsis)
geomtype(rivers)
geomtype(coast)

is.points(dypsis)
is.points(coast)

is.lines(rivers)
is.lines(dypsis)

is.polygons(coast)
is.polygons(dypsis)

# Number of dimensions:
topology(rivers)
is.2d(rivers) # 2-dimensional?
is.3d(rivers) # 3-dimensional?

# Just the data table:
as.data.frame(rivers)
as.data.table(rivers)

# Top/bottom of the data table:
head(rivers)
tail(rivers)

# Vector or table with just selected columns:
names(rivers)
rivers$NAME
rivers[[c("NAM", "NAME_0")]]
rivers[[c(3, 5)]]

# Select geometries/rows of the vector:
nrow(rivers)
selected <- rivers[2:6]
nrow(selected)

# Plot:
plot(coast)
plot(rivers, col = "blue", add = TRUE)
plot(selected, col = "red", lwd = 2, add = TRUE)

# Vector math:
hull <- convHull(dypsis)

un <- union(coast, hull)
sameAsUnion <- coast + hull
plot(un)
plot(sameAsUnion)

inter <- intersect(coast, hull)
sameAsIntersect <- coast * hull
plot(inter)
plot(sameAsIntersect)

er <- erase(coast, hull)
sameAsErase <- coast - hull
plot(er)
plot(sameAsErase)

xr <- xor(coast, hull)
sameAsXor <- coast / hull
plot(xr)
plot(sameAsXor)

# Vector area and length:
expanse(coast, unit = "km") # polygons areas
expanse(rivers, unit = "km") # river lengths

### Fill holes

# First, we will make some holes by creating buffers around points.
buffs <- buffer(dypsis, 500)

holes <- coast - buffs
plot(holes)

filled <- fillHoles(holes, fail = FALSE)

}
}
\seealso{
\code{\link[terra:fill]{terra::fillHoles()}}, \strong{GRASS} manual page for tool \code{v.fill.holes} (see \code{grassHelp("v.fill.holes")})
}
