% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makelists.R
\name{add_target}
\alias{add_target}
\title{Add a Target to a Makelist}
\usage{
add_target(
  makelist,
  target,
  code,
  prerequisites = NULL,
  prerequisite_to = NULL,
  sink = NULL,
  alias = sub("\\\\.(Rout|log)$", "", basename(target))
)
}
\arguments{
\item{makelist}{A list for
\code{\link[fakemake:make]{make}}.}

\item{target}{The target to remove from \code{makelist}.}

\item{code}{The code for the new target.}

\item{prerequisites}{The prerequisites for the new target.}

\item{prerequisite_to}{The targets the new target is a prerequisite to.
Set to \code{\link{TRUE}} to add it as a prerequisite to all existing
targets.}

\item{sink}{The sink for the new target.}

\item{alias}{The alias for the new target.}
}
\value{
A list for
\code{\link[fakemake:make]{make}}.
}
\description{
Add a target to an existing \code{makelist}.
}
\seealso{
Other functions to manipulate makelists: 
\code{\link{get_target}()},
\code{\link{remove_target}()}
}
\concept{functions to manipulate makelists}
