% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fmTstats.R
\name{fmTstats}
\alias{fmTstats}
\title{fmTstats.ffm t-stats and plots for a fitted Fundamental Factor Model object}
\usage{
fmTstats(
  ffmObj,
  isPlot = TRUE,
  isPrint = FALSE,
  whichPlot = "tStats",
  color = c("black", "cyan"),
  lwd = 2,
  digits = 2,
  z.alpha = 1.96,
  layout = c(2, 3),
  type = "h",
  scale = "free",
  stripText.cex = 1,
  axis.cex = 1,
  title = TRUE,
  ...
)
}
\arguments{
\item{ffmObj}{an object of class \code{ffm} produced by \code{fitFfm}}

\item{isPlot}{logical. If \code{FALSE} no plots are displayed.}

\item{isPrint}{logical. if \code{TRUE}, the time series of the computed 
factor model values is printed. Default is \code{FALSE}}

\item{whichPlot}{string indicating the plot(s) to be plotted. Choose from 
("all", "tStats", "significantTstatsV", "significantTstatsH", "significantTstatsLikert").
Three variants of significantTstats stand for vertical, horizontal and likert barplots. 
Default is \code{tStats} plotting t-stats and significant t-stats with vertical bars.}

\item{color}{length 2 vector specifying the plotting color for t-stats plot 
and for barplot respectively. default is \code{c("black", "cyan")}}

\item{lwd}{line width relative to the default. default is 2.}

\item{digits}{an integer indicating the number of decimal places to be used 
for rounding. default is 2.}

\item{z.alpha}{critical value corresponding to the confidence interval. 
Default is 1.96 i.e 95\% C.I}

\item{layout}{numeric vector of length 2 or 3 giving the number of columns, 
rows, and pages (optional) in the xyplot of t-statistics. default is c(2,3).}

\item{type}{type character. Type of the xyplot of t-statistics; \code{"l"} 
for lines, \code{"p"} for points, \code{"h"} for histogram like (or high-density) 
vertical lines and \code{"b"} for both. Default is \code{"h"}.}

\item{scale}{character. It determines how axis limits are calculated for each 
panel. Possible values are "same" , "free" (default) and "sliced".}

\item{stripText.cex}{a number indicating the amount by which strip text in 
the plot(s) should be scaled relative to the default. 1=default, 1.5 is 50\% 
larger, 0.5 is 50\% smaller, etc.}

\item{axis.cex}{a number indicating the amount by which axis in the plot(s) 
should be scaled relative to the default. Default = 1. 1.5 is 50\% larger, 
0.5 is 50\% smaller, etc.}

\item{title}{logical. if \code{TRUE}, the plots will have the main title. 
Default is \code{TRUE}.}

\item{...}{potentially further arguments passed.}
}
\value{
\code{fmTstats} plots the t-stats and significant t-stats values  
if \code{isPlot} is \code{TRUE} and returns a list with following components:
\item{tstats}{ an xts object of t-stats values.}
\item{z.alpha}{ critical value corresponding to the confidence interval.}
}
\description{
Calculate and plot the time series of t-statistic values and the
 number of risk indices with significant t-stats for a fundamental factor 
 model of class \code{ffm} produced by \code{fitFfm} or \code{fitFfmDT}
}
\examples{
\donttest{
library(PCRA)
# load data 
data(stocksCRSP)
data(factorsSPGMI)
dateRange <- c("2006-01-31","2010-12-31")
stockItems <-  c("Date", "TickerLast", "CapGroupLast", "Return",
                "Ret13WkBill","MktIndexCRSP","Sector")
                factorItems <- c("BP","Beta60M","PM12M1M")
stocks_factors <- selectCRSPandSPGMI("monthly", dateRange = dateRange, 
stockItems = stockItems, factorItems = factorItems, outputType ="data.table")
                                    

# fit a fundamental factor model with style variables BP and LogMktCap

fundamental_model <- fitFfm(data = stocks_factors, 
                           asset.var = "TickerLast", 
                           ret.var = "Return", 
                           date.var = "Date", 
                           exposure.vars = c("BP", "PM12M1M")
                           )

#Compute time series of t-stats and number of significant t-stats 
 stats = fmTstats(fundamental_model, isPlot = TRUE, lwd = 2, color = c("blue", "blue"), 
                  z.alpha = 1.96)
               
# Fit a SECTOR+COUNTRY+Style model with Intercept
# Create a COUNTRY column with just 3 countries
#
#  factorDataSetDjia5Yrs$COUNTRY = rep(rep(c(rep("US", 1 ), rep("GERMANY", 1 )), 11), 60)
# 
#  fit.MICM <- fitFfm(data = factorDataSetDjia5Yrs, 
#                    asset.var = "TICKER",
#                    exposure.vars = c("SECTOR", "COUNTRY","P2B", "MKTCAP"),
#                    ret.var = "RETURN", 
#                    date.var = "DATE", 
#                    addIntercept = FALSE)
#  
 # Load library 'HH' to access the Likert option
#  library("HH")                   
#  stats = fmTstats(fit.MICM, isPlot = TRUE, z.alpha =1.96,
#                   whichPlot = "significantTstatsLikert")
}
}
\author{
Avinash Acharya and Doug Martin
}
