% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{tidy.fbl_prophet}
\alias{tidy.fbl_prophet}
\title{Extract estimated coefficients from a prophet model}
\usage{
\method{tidy}{fbl_prophet}(x, ...)
}
\arguments{
\item{x}{An object to be converted into a tidy \code{\link[tibble:tibble]{tibble::tibble()}}.}

\item{...}{Additional arguments to tidying method.}
}
\value{
A tibble containing the model's estimated parameters.
}
\description{
Extract estimated coefficients from a prophet model
}
\examples{

\donttest{
if (requireNamespace("tsibbledata")) {
library(tsibble)
library(dplyr)
fit <- tsibbledata::aus_production \%>\%
  model(
    prophet = prophet(Beer ~ season("year", 4, type = "multiplicative"))
  )

tidy(fit) # coef(fit) or coefficients(fit) can also be used
}
}

}
