% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sacf.R
\name{sacf}
\alias{sacf}
\title{Functional Spherical Autocorrelation Function}
\usage{
sacf(X, lag.max = 20, alpha = 0.05, figure = TRUE)
}
\arguments{
\item{X}{A dfts object or data which can be automatically converted to that
format. See \code{\link[=dfts]{dfts()}}.}

\item{lag.max}{A positive integer value. The maximum lag for which to compute
the coefficients and confidence bounds.}

\item{alpha}{Significance in [0,1] for intervals when forecasting.}

\item{figure}{Logical. If \code{TRUE}, prints plot for the estimated
function with the specified bounds.}
}
\value{
List with sACF values and plots
}
\description{
This function offers a graphical summary of the fSACF of a
functional time series (FTS) across different time lags \eqn{h = 1:H}.
It also plots \eqn{100 \times (1-\alpha)\%}  confidence bounds developed
under strong white noise (SWN) assumption for all lags \eqn{h = 1:H}.
}
\details{
This function computes and plots functional spherical
autocorrelation coefficients at lag \eqn{h}, for \eqn{h = 1:H}.
The fSACF at lag \eqn{h} is computed by the average of the inner product of
lagged pairs of the series \eqn{X_i} and \eqn{X_{i+h}} that have been
centered and scaled:
\deqn{
  \tilde\rho_h=\frac{1}{N}\sum_{i=1}^{N-h} \langle \frac{X_i - \tilde{\mu}}{\|X_i - \tilde{\mu}\|}, \frac{X_{i+h} - \tilde{\mu}}{\|X_{i+h} - \tilde{\mu}\|} \rangle,\ \ \ \ 0 \le h < N,
 }
where \eqn{\tilde{\mu}} is the estimated spatial median of the series.
It also computes estimated asymptotic \eqn{(1-\alpha)100 \%} confidence lower
and upper bounds, under the SWN assumption.
}
\examples{
sacf(electricity)
sacf(generate_brownian_motion(100))
}
\references{
Yeh C.K., Rice G., Dubin J.A. (2023). Functional spherical
autocorrelation: A robust estimate of the autocorrelation of a functional
time series. Electronic Journal of Statistics, 17, 650–687.
}
\seealso{
\code{\link[=acf]{acf()}}
}
