% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{data_dict_md}
\alias{data_dict_md}
\title{Create a data dictionary Markdown file}
\usage{
data_dict_md(
  data,
  title = "",
  description = NA,
  output_file = "data_dict.md",
  output_dir
)
}
\arguments{
\item{data}{A dataframe (data dictionary for all variables)}

\item{title}{Title of the data dictionary}

\item{description}{Detailed description of variables in data (dataframe with columns 'variable' and 'description')}

\item{output_file}{Output filename for Markdown file}

\item{output_dir}{Directory where the Markdown file is saved}
}
\value{
Create Markdown file
}
\description{
Create a data dictionary Markdown file
}
\examples{
# Data dictionary of a dataframe
data_dict_md(iris,
             title = "iris flower data set",
             output_dir = tempdir())

# Data dictionary of a dataframe with additional description of variables
description <- data.frame(
                 variable = c("Species"),
                 description = c("Species of Iris flower"))
data_dict_md(iris,
             title = "iris flower data set",
             description = description,
             output_dir = tempdir())
}
